/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.client.gui.submenu;

import com.silvaniastudios.graffiti.client.gui.GuiCanvasEditorBase;
import com.silvaniastudios.graffiti.client.gui.submenu.GuiCanvasEditorMain;
import com.silvaniastudios.graffiti.client.gui.submenu.ImportJsonScreen;
import com.silvaniastudios.graffiti.client.gui.widget.JsonListWidget;
import com.silvaniastudios.graffiti.drawables.PixelGridDrawable;
import com.silvaniastudios.graffiti.tileentity.ContainerGraffiti;
import com.silvaniastudios.graffiti.util.FileImport;
import com.silvaniastudios.graffiti.util.ImportedJsonObject;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;

public class ImportListMenu
extends GuiCanvasEditorBase {
    private static final ResourceLocation LIST_TEXTURE = new ResourceLocation("graffiti", "textures/gui/json_list.png");
    boolean showArt = false;
    PixelGridDrawable grid;
    Button backBtn;
    Button refreshBtn;
    Button openFolderBtn;
    JsonListWidget listWidget;
    File[] jsonList;

    public ImportListMenu(ContainerGraffiti container, PlayerInventory inv, ITextComponent text) {
        super(container, inv, text);
        this.grid = this.graffiti.pixelGrid;
        this.jsonList = new File("./graffiti/").listFiles();
    }

    private void initButtons() {
        int startX = this.width / 2 - this.field_146999_f / 2;
        int startY = this.height / 2 - this.field_147000_g / 2;
        ArrayList<ImportedJsonObject> jsons = this.populateJsonList();
        this.backBtn = new Button(startX + 7, startY + 221, 78, 20, "Back", p_214266_1_ -> this.minecraft.func_147108_a((Screen)new GuiCanvasEditorMain((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title)));
        this.refreshBtn = new Button(startX + 89, startY + 221, 78, 20, "Refresh", p_214266_1_ -> this.listWidget.refresh(this.populateJsonList()));
        this.openFolderBtn = new Button(startX + 171, startY + 221, 78, 20, "Open Folder", p_214266_1_ -> Util.func_110647_a().func_195641_a(new File("./graffiti/")));
        this.listWidget = new JsonListWidget(this.minecraft, 240, 209, startY + 7, startX + 8, 48, jsons, (Screen)this);
    }

    private ArrayList<ImportedJsonObject> populateJsonList() {
        this.jsonList = new File("./graffiti/").listFiles();
        ArrayList<ImportedJsonObject> jsons = new ArrayList<ImportedJsonObject>();
        for (int i = 0; i < this.jsonList.length; ++i) {
            ImportedJsonObject ijo = FileImport.importFileInfoBasic(this.jsonList[i]);
            if (ijo == null) continue;
            jsons.add(ijo);
        }
        return jsons;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollAmount) {
        this.listWidget.mouseScrolled(mouseX, mouseY, scrollAmount);
        return super.mouseScrolled(mouseX, mouseY, scrollAmount);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.listWidget.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.listWidget.mouseClicked(mouseX, mouseY, button);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.initButtons();
        this.addButton((Widget)this.backBtn);
        this.addButton((Widget)this.refreshBtn);
        this.addButton((Widget)this.openFolderBtn);
        super.init();
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        super.render(mouseX, mouseY, partialTick);
        int startX = this.width / 2 - this.field_146999_f / 2;
        int startY = this.height / 2 - this.field_147000_g / 2;
        this.minecraft.func_110434_K().func_110577_a(LIST_TEXTURE);
        this.blit(startX + 7, startY + 7, 0, 0, 242, 100);
        this.blit(startX + 7, startY + 107, 0, 50, 242, 110);
        this.listWidget.render(mouseX, mouseY, partialTick);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
    }

    public void openEditText(int id) {
        ImportedJsonObject json = FileImport.importFile(this.jsonList[id], this.tileEntity, ((ContainerGraffiti)this.field_147002_h).graffiti.getSide());
        this.minecraft.func_147108_a((Screen)new ImportJsonScreen(json, (ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title));
    }
}

