/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.client.gui.submenu;

import com.silvaniastudios.graffiti.client.gui.GuiCanvasEditorBase;
import com.silvaniastudios.graffiti.client.gui.submenu.GuiCanvasEditorMain;
import com.silvaniastudios.graffiti.drawables.PixelGridDrawable;
import com.silvaniastudios.graffiti.network.GraffitiPacketHandler;
import com.silvaniastudios.graffiti.network.ModifyGridPacket;
import com.silvaniastudios.graffiti.tileentity.ContainerGraffiti;
import com.silvaniastudios.graffiti.util.GraffitiUtils;
import java.util.ArrayList;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class PixelGridMenu
extends GuiCanvasEditorBase {
    int sizeId = 0;
    boolean resize = true;
    boolean deleteFlag = false;
    boolean showText = false;
    PixelGridDrawable grid;
    Button decreaseGridSizeBtn;
    Button increaseGridSizeBtn;
    Button resizeBtn;
    Button deleteBtn;
    Button yesBtn;
    Button noBtn;
    Button showHideTextBtn;
    Button resetTransparencyBtn;
    Button transparencyIncreaseBtn;
    Button transparencyDecreaseBtn;
    Button saveBtn;
    Button discardBtn;
    Slider transparencySldr;

    public PixelGridMenu(ContainerGraffiti container, PlayerInventory inv, ITextComponent text) {
        super(container, inv, text);
        this.grid = this.graffiti.pixelGrid;
        this.sizeId = GraffitiUtils.sizeToId(this.grid.getSize());
        this.field_147000_g = 196;
    }

    private void initButtons() {
        int startX = this.width / 2 - this.field_146999_f / 2;
        int startY = this.height / 2 - this.field_147000_g / 2;
        this.decreaseGridSizeBtn = new Button(startX + 141, startY + 21, 20, 20, "-", p_214266_1_ -> {
            if (this.sizeId > 0) {
                --this.sizeId;
                this.increaseGridSizeBtn.active = true;
                this.validateGridScaling();
            }
            if (this.sizeId == 0) {
                this.decreaseGridSizeBtn.active = false;
            }
        });
        this.increaseGridSizeBtn = new Button(startX + 228, startY + 21, 20, 20, "+", p_214266_1_ -> {
            if (this.sizeId < 3) {
                ++this.sizeId;
                this.decreaseGridSizeBtn.active = true;
                this.validateGridScaling();
            }
            if (this.sizeId == 3) {
                this.increaseGridSizeBtn.active = false;
            }
        });
        this.resizeBtn = new Button(startX + 141, startY + 45, 108, 20, "Resize: " + this.resize, p_214266_1_ -> {
            this.resize = !this.resize;
            this.validateGridScaling();
            ((Widget)this.buttons.get(2)).setMessage("Resize: " + this.resize);
        });
        this.deleteBtn = new Button(startX + 141, startY + 69, 108, 20, "Delete Grid", p_214266_1_ -> this.toggleDeleteMenu(true));
        this.yesBtn = new Button(startX + 141, startY + 117, 44, 20, "Yes", p_214266_1_ -> {
            if (this.deleteFlag) {
                GraffitiPacketHandler.INSTANCE.sendToServer((Object)new ModifyGridPacket(0, this.transparencySldr.getValueInt(), this.resize));
                this.toggleDeleteMenu(false);
            }
        });
        this.noBtn = new Button(startX + 204, startY + 117, 44, 20, "No", p_214266_1_ -> {
            if (this.deleteFlag) {
                this.toggleDeleteMenu(false);
            }
        });
        this.showHideTextBtn = new Button(startX + 141, startY + 117, 108, 20, "Show Text", p_214266_1_ -> {
            this.showText = !this.showText;
            this.showHideTextBtn.setMessage(this.showText ? "Hide Text" : "Show Text");
        });
        this.transparencySldr = new Slider(startX + 17, startY + 141, 178, 20, "Transparency: ", "", 0.0, 255.0, 255.0, false, true, p_214266_1_ -> {});
        this.resetTransparencyBtn = new Button(startX + 209, startY + 141, 40, 20, "Reset", p_214266_1_ -> {
            this.transparencySldr.setValue(255.0);
            this.transparencySldr.updateSlider();
        });
        this.discardBtn = new Button(startX + 7, startY + 169, 110, 20, "Discard Changes", p_214266_1_ -> this.minecraft.func_147108_a((Screen)new GuiCanvasEditorMain((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title)));
        this.saveBtn = new Button(startX + 139, startY + 169, 110, 20, "Save Changes", p_214266_1_ -> {
            int size = 0;
            if (this.sizeId == 0) {
                size = 16;
            } else if (this.sizeId == 1) {
                size = 32;
            } else if (this.sizeId == 2) {
                size = 64;
            } else if (this.sizeId == 3) {
                size = 128;
            }
            GraffitiPacketHandler.INSTANCE.sendToServer((Object)new ModifyGridPacket(size, (int)Math.round(this.transparencySldr.getValue()), this.resize));
            this.minecraft.func_147108_a((Screen)new GuiCanvasEditorMain((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title));
        });
        this.transparencyDecreaseBtn = new Button(startX + 7, startY + 141, 10, 20, "-", p_214266_1_ -> {
            this.transparencySldr.setValue(this.transparencySldr.getValue() - 1.0);
            this.transparencySldr.updateSlider();
        });
        this.transparencyIncreaseBtn = new Button(startX + 195, startY + 141, 10, 20, "+", p_214266_1_ -> {
            this.transparencySldr.setValue(this.transparencySldr.getValue() + 1.0);
            this.transparencySldr.updateSlider();
        });
        this.transparencySldr.setValue((double)this.graffiti.pixelGrid.getTransparency());
        this.transparencySldr.updateSlider();
    }

    protected void validateGridScaling() {
        this.grid = new PixelGridDrawable(GraffitiUtils.rescaleMultiple(this.graffiti.pixelGrid.getPixelGrid(), GraffitiUtils.idToSize(this.sizeId), this.resize));
    }

    @Override
    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.initButtons();
        this.addButton((Widget)this.decreaseGridSizeBtn);
        this.addButton((Widget)this.increaseGridSizeBtn);
        this.addButton((Widget)this.resizeBtn);
        this.addButton((Widget)this.deleteBtn);
        this.addButton((Widget)this.yesBtn);
        this.addButton((Widget)this.noBtn);
        this.addButton((Widget)this.showHideTextBtn);
        this.addButton((Widget)this.resetTransparencyBtn);
        this.addButton((Widget)this.transparencySldr);
        this.addButton((Widget)this.saveBtn);
        this.addButton((Widget)this.discardBtn);
        this.addButton((Widget)this.transparencyDecreaseBtn);
        this.addButton((Widget)this.transparencyIncreaseBtn);
        if (this.sizeId == 0) {
            this.decreaseGridSizeBtn.active = false;
        }
        if (this.sizeId == 3) {
            this.increaseGridSizeBtn.active = false;
        }
        this.toggleDeleteMenu(false);
        super.init();
    }

    private void toggleDeleteMenu(boolean b) {
        this.deleteFlag = b;
        this.yesBtn.active = b;
        this.yesBtn.visible = b;
        this.noBtn.active = b;
        this.noBtn.visible = b;
        this.showHideTextBtn.active = !b;
        this.showHideTextBtn.visible = !b;
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        this.blit(i, j + 189, 0, 249, this.field_146999_f, 7);
        this.drawGraffiti(this.graffiti, true, this.showText);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawCenteredString(this.font, "Pixel Grid", 195, 8, 0x404040);
        if (this.sizeId == 0) {
            this.drawCenteredString(this.font, "16x16", 195, 27, 0x404040);
        }
        if (this.sizeId == 1) {
            this.drawCenteredString(this.font, "32x32", 195, 27, 0x404040);
        }
        if (this.sizeId == 2) {
            this.drawCenteredString(this.font, "64x64", 195, 27, 0x404040);
        }
        if (this.sizeId == 3) {
            this.drawCenteredString(this.font, "128x128", 195, 27, 0x404040);
        }
        if (this.deleteFlag) {
            this.drawCenteredString(this.font, "Are you sure?", 195, 94, 0x404040);
            this.drawCenteredString(this.font, "This can't be undone!", 195, 104, 0x404040);
        }
        if (this.resizeBtn.isHovered()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("Whether to resize the image when rescaling");
            list.add("True: the image will attempt to look the same as before it was rescaled.");
            list.add("False: the image will move to the top-left, or crop to only show the previous top-left.");
            this.renderTooltip(list, mouseX, mouseY);
        }
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.transparencySldr.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }
}

