/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.client.gui.submenu;

import com.silvaniastudios.graffiti.client.gui.GuiCanvasEditorBase;
import com.silvaniastudios.graffiti.client.gui.submenu.GuiCanvasEditorMain;
import com.silvaniastudios.graffiti.network.GraffitiPacketHandler;
import com.silvaniastudios.graffiti.network.RightClickActionPacket;
import com.silvaniastudios.graffiti.tileentity.ContainerGraffiti;
import java.util.ArrayList;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class RightClickActionMenu
extends GuiCanvasEditorBase {
    Button noActionBtn;
    Button clickThroughBtn;
    Button displayArtBtn;
    Button openUrlBtn;
    Button saveBtn;
    Button discardBtn;
    Slider backgroundTransparency;
    int rightClickActionId;
    private TextFieldWidget webUrl;
    private static final ResourceLocation TEXTURE = new ResourceLocation("graffiti", "textures/gui/widgets.png");

    public RightClickActionMenu(ContainerGraffiti container, PlayerInventory inv, ITextComponent text) {
        super(container, inv, text);
        this.field_146999_f = 218;
        this.field_147000_g = 121;
        this.rightClickActionId = this.graffiti.getRightClickAction();
    }

    @Override
    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.initButtons();
        this.addButton((Widget)this.noActionBtn);
        this.addButton((Widget)this.clickThroughBtn);
        this.addButton((Widget)this.displayArtBtn);
        this.addButton((Widget)this.openUrlBtn);
        this.addButton((Widget)this.backgroundTransparency);
        this.addButton((Widget)this.saveBtn);
        this.addButton((Widget)this.discardBtn);
        super.init();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawCenteredString(this.font, "Set right-click mode", this.field_146999_f / 2, 7, 0x404040);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        this.blit(i, j, 0, 93, this.field_146999_f, this.field_147000_g);
    }

    private void initButtons() {
        int startX = this.width / 2 - this.field_146999_f / 2;
        int startY = this.height / 2 - this.field_147000_g / 2;
        this.webUrl = new TextFieldWidget(this.font, startX + 7, startY + 66, 204, 16, "");
        this.webUrl.func_146205_d(false);
        this.webUrl.changeFocus(true);
        this.webUrl.func_146193_g(-1);
        this.webUrl.func_146185_a(true);
        this.webUrl.func_146203_f(500);
        this.children.add(this.webUrl);
        this.func_212928_a((IGuiEventListener)this.webUrl);
        this.backgroundTransparency = new Slider(startX + 7, startY + 66, 204, 20, "Background Transparency: ", "", 0.0, 255.0, 0.0, false, true, p_214266_1_ -> {});
        this.clickThroughBtn = new Button(startX + 111, startY + 18, 100, 20, "Click-Through", p_214266_1_ -> {
            this.clickThroughBtn.active = false;
            this.noActionBtn.active = true;
            this.displayArtBtn.active = true;
            this.openUrlBtn.active = true;
            this.rightClickActionId = 0;
            this.backgroundTransparency.active = false;
            this.backgroundTransparency.visible = false;
            this.webUrl.active = false;
            this.webUrl.visible = false;
        });
        this.noActionBtn = new Button(startX + 7, startY + 18, 100, 20, "No Action", p_214266_1_ -> {
            this.noActionBtn.active = false;
            this.clickThroughBtn.active = true;
            this.displayArtBtn.active = true;
            this.openUrlBtn.active = true;
            this.rightClickActionId = 1;
            this.backgroundTransparency.active = false;
            this.backgroundTransparency.visible = false;
            this.webUrl.active = false;
            this.webUrl.visible = false;
        });
        this.displayArtBtn = new Button(startX + 7, startY + 42, 100, 20, "Display Art", p_214266_1_ -> {
            this.displayArtBtn.active = false;
            this.noActionBtn.active = true;
            this.clickThroughBtn.active = true;
            this.openUrlBtn.active = true;
            this.rightClickActionId = 2;
            this.backgroundTransparency.active = true;
            this.backgroundTransparency.visible = true;
            this.webUrl.active = false;
            this.webUrl.visible = false;
        });
        this.openUrlBtn = new Button(startX + 111, startY + 42, 100, 20, "Open URL", p_214266_1_ -> {
            this.openUrlBtn.active = false;
            this.noActionBtn.active = true;
            this.displayArtBtn.active = true;
            this.clickThroughBtn.active = true;
            this.rightClickActionId = 3;
            this.backgroundTransparency.active = false;
            this.backgroundTransparency.visible = false;
            this.webUrl.active = true;
            this.webUrl.visible = true;
        });
        this.backgroundTransparency.active = false;
        this.backgroundTransparency.visible = false;
        this.webUrl.active = false;
        this.webUrl.visible = false;
        if (this.rightClickActionId == 0) {
            this.clickThroughBtn.active = false;
        }
        if (this.rightClickActionId == 1) {
            this.noActionBtn.active = false;
        }
        if (this.rightClickActionId == 2) {
            this.displayArtBtn.active = false;
            this.backgroundTransparency.active = true;
            this.backgroundTransparency.visible = true;
        }
        if (this.rightClickActionId == 3) {
            this.openUrlBtn.active = false;
            this.webUrl.func_146180_a(this.graffiti.getUrl());
            this.webUrl.active = true;
            this.webUrl.visible = true;
        }
        this.discardBtn = new Button(startX + 7, startY + 94, 100, 20, "Discard Changes", p_214266_1_ -> this.minecraft.func_147108_a((Screen)new GuiCanvasEditorMain((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title)));
        this.saveBtn = new Button(startX + 111, startY + 94, 100, 20, "Save Changes", p_214266_1_ -> {
            GraffitiPacketHandler.INSTANCE.sendToServer((Object)new RightClickActionPacket(this.rightClickActionId, this.backgroundTransparency.getValueInt(), this.webUrl.func_146179_b()));
            this.minecraft.func_147108_a((Screen)new GuiCanvasEditorMain((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title));
        });
    }

    @Override
    public void render(int mouseX, int mouseY, float p_render_3_) {
        ArrayList<String> list;
        super.render(mouseX, mouseY, p_render_3_);
        this.webUrl.render(mouseX, mouseY, p_render_3_);
        if (this.noActionBtn.isHovered()) {
            list = new ArrayList<String>();
            list.add("Right-click does nothing");
            this.renderTooltip(list, mouseX, mouseY);
        }
        if (this.clickThroughBtn.isHovered()) {
            list = new ArrayList();
            list.add("Right-click will activate the block behind the graffiti");
            list.add("For example, opening a chest you've written on.");
            this.renderTooltip(list, mouseX, mouseY);
        }
        if (this.displayArtBtn.isHovered()) {
            list = new ArrayList();
            list.add("Right-click shows the graffiti as a UI");
            this.renderTooltip(list, mouseX, mouseY);
        }
        if (this.openUrlBtn.isHovered()) {
            list = new ArrayList();
            list.add("Right-click opens the prompt to open a custom web address");
            this.renderTooltip(list, mouseX, mouseY);
        }
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.minecraft.field_71439_g.func_71053_j();
        }
        return !this.webUrl.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) && !this.webUrl.func_212955_f() ? super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : true;
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.backgroundTransparency.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }
}

