/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.client.gui.widget;

import com.silvaniastudios.graffiti.client.gui.widget.ColorDisplayWidget;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;

public class ColorGridWidget
extends Widget {
    private boolean mouseDrag = false;
    private boolean showSelectorBoxes = true;
    private int colorSelectedPos = 0;
    private int colorGridPosX = 127;
    private int colorGridPosY = 0;
    private int gapSize;
    private boolean colorGridFocused = false;
    int finalColour = -1;
    Minecraft minecraft = Minecraft.func_71410_x();
    ColorDisplayWidget display;
    private static final ResourceLocation TEXTURE = new ResourceLocation("graffiti", "textures/gui/color_picker_widget.png");

    public ColorGridWidget(int xIn, int yIn, int gapSize, ColorDisplayWidget display) {
        super(xIn, yIn, 148 + gapSize, 130, "");
        this.gapSize = gapSize;
        this.display = display;
        this.finalColour = this.getSlidersColor().getRGB();
    }

    public ColorGridWidget(int xIn, int yIn, int gapSize) {
        this(xIn, yIn, gapSize, null);
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            this.minecraft.func_110434_K().func_110577_a(TEXTURE);
            this.blit(this.x, this.y, 0, 0, 130, 130);
            this.blit(this.x + 130 + this.gapSize, this.y, 130, 0, 18, 130);
            for (int i = 0; i < 128; ++i) {
                int targetCol = this.getColorBrightness(Math.abs(i - 128)).getRGB();
                this.fillGradient(this.x + 1 + i, this.y + 1, this.x + 2 + i, this.y + 128, targetCol, Color.BLACK.getRGB());
            }
            if (this.showSelectorBoxes) {
                this.blit(this.x + this.colorGridPosX, this.y + this.colorGridPosY, 0, 130, 3, 3);
                this.blit(this.x + 130 + this.gapSize, this.y + this.colorSelectedPos, 3, 130, 18, 3);
            }
            if (this.display != null) {
                this.display.setColor(this.finalColour);
                this.display.render(mouseX, mouseY, partialTick);
            }
            if (this.mouseDrag) {
                if (mouseX >= this.x && mouseX <= this.x + this.width - 18 - this.gapSize && mouseY >= this.y && mouseY <= this.y + this.height) {
                    this.colorGridPosX = (int)Math.floor(mouseX - this.x);
                    this.colorGridPosY = (int)Math.floor(mouseY - this.y);
                }
                if (mouseX >= this.x + 130 + this.gapSize && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height) {
                    this.colorSelectedPos = (int)Math.floor(mouseY - this.y);
                }
            }
            if (this.colorGridPosX > 127) {
                this.colorGridPosX = 127;
            }
            if (this.colorGridPosY > 127) {
                this.colorGridPosY = 127;
            }
            if (this.colorSelectedPos > 127) {
                this.colorSelectedPos = 127;
            }
        }
    }

    public int getScaledPosition(int start, int end, int currentRGB, int targetRGB) {
        int totalSteps = end - start;
        float increments = (float)totalSteps / 255.0f;
        if (targetRGB == 255) {
            return (int)((float)currentRGB * increments) + start;
        }
        if (targetRGB == 0) {
            return end - (int)((float)currentRGB * increments);
        }
        return 0;
    }

    public void onClick(double mouseX, double mouseY) {
        this.mouseDrag = true;
        this.showSelectorBoxes = true;
    }

    public void releaseMouse() {
        if (this.mouseDrag) {
            this.finalColour = this.getSlidersColor().getRGB();
        }
        this.mouseDrag = false;
    }

    public void setColour(int colIn) {
        this.finalColour = colIn;
        this.showSelectorBoxes = false;
    }

    public Color getColorBrightness(int pos) {
        int selected = this.colorSelectedPos;
        int r = 0;
        int g = 0;
        int b = 0;
        if (selected < 21) {
            r = 255;
            g = this.interpolatedValue(selected, pos);
            g = this.constrain(g);
            b = this.constrain(pos * 2);
        } else if (selected < 43) {
            r = this.interpolatedValue(Math.abs(selected - 42), pos);
            r = this.constrain(r);
            g = 255;
            b = this.constrain(pos * 2);
        } else if (selected < 64) {
            r = this.constrain(pos * 2);
            g = 255;
            b = this.interpolatedValue(selected - 43, pos);
            b = this.constrain(b);
        } else if (selected < 85) {
            r = this.constrain(pos * 2);
            g = this.interpolatedValue(Math.abs(selected - 85), pos);
            g = this.constrain(g);
            b = 255;
        } else if (selected < 106) {
            r = this.interpolatedValue(selected - 85, pos);
            r = this.constrain(r);
            g = this.constrain(pos * 2);
            b = 255;
        } else {
            r = 255;
            g = this.constrain(pos * 2);
            b = this.interpolatedValue(Math.abs(selected - 127), pos);
            b = this.constrain(b);
        }
        if (r > 250) {
            r = 255;
        }
        if (g > 250) {
            g = 255;
        }
        if (b > 250) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    private int interpolatedValue(int sel, int pos) {
        int var = sel * 12;
        int remain = 255 - var;
        float add = (float)remain / 127.0f * (float)pos;
        return (int)((float)var + add);
    }

    public Color getSlidersColor() {
        Color brightness = this.getColorBrightness(Math.abs(this.colorGridPosX - 128));
        int r = this.constrain(this.calculateDarkness(brightness.getRed()));
        int g = this.constrain(this.calculateDarkness(brightness.getGreen()));
        int b = this.constrain(this.calculateDarkness(brightness.getBlue()));
        return new Color(r, g, b);
    }

    public int getColor() {
        return this.finalColour;
    }

    public int calculateDarkness(int in) {
        if (in > 0) {
            in = (int)((double)in / 127.0 * (double)Math.abs(this.colorGridPosY - 127));
        }
        return in;
    }

    private int constrain(int in) {
        if (in < 5) {
            in = 0;
        }
        return in > 255 ? 255 : in;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width - 18 - this.gapSize) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height)) {
            this.colorGridPosX = (int)Math.floor(mouseX - (double)this.x);
            this.colorGridPosY = (int)Math.floor(mouseY - (double)this.y);
            this.colorGridFocused = true;
            this.finalColour = this.getSlidersColor().getRGB();
        }
        if (mouseX >= (double)(this.x + 130 + this.gapSize) && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height)) {
            this.colorSelectedPos = (int)Math.floor(mouseY - (double)this.y);
            this.colorGridFocused = false;
            this.finalColour = this.getSlidersColor().getRGB();
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyID, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.colorGridFocused) {
            if (keyID == 265 && this.colorGridPosY > 0) {
                --this.colorGridPosY;
            }
            if (keyID == 264 && this.colorGridPosY < 127) {
                ++this.colorGridPosY;
            }
            if (keyID == 263 && this.colorGridPosX > 0) {
                --this.colorGridPosX;
            }
            if (keyID == 262 && this.colorGridPosX < 127) {
                ++this.colorGridPosX;
            }
            if (keyID >= 262 && keyID <= 265) {
                this.finalColour = this.getSlidersColor().getRGB();
            }
        } else {
            if (keyID == 265 && this.colorSelectedPos > 0) {
                --this.colorSelectedPos;
            }
            if (keyID == 264 && this.colorSelectedPos < 127) {
                ++this.colorSelectedPos;
            }
            if (keyID == 264 || keyID == 265) {
                this.finalColour = this.getSlidersColor().getRGB();
            }
        }
        return super.keyPressed(keyID, p_keyPressed_2_, p_keyPressed_3_);
    }
}

