/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.client.gui.widget;

import com.silvaniastudios.graffiti.client.gui.submenu.ImportListMenu;
import com.silvaniastudios.graffiti.util.ImportedJsonObject;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.gui.ScrollPanel;

public class JsonListWidget
extends ScrollPanel {
    private final Minecraft mc;
    private static final ResourceLocation TEXTURE = new ResourceLocation("graffiti", "textures/gui/json_list.png");
    private ArrayList<ImportedJsonObject> jsons;
    private int entryHeight;
    private Screen parent;

    public JsonListWidget(Minecraft client, int width, int height, int top, int left, int entryHeight, ArrayList<ImportedJsonObject> jsons, Screen parent) {
        super(client, width, height, top, left);
        this.mc = client;
        this.entryHeight = entryHeight;
        this.jsons = jsons;
        this.parent = parent;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int element;
        if (this.isMouseOver(mouseX, mouseY) && (element = this.getElementId((int)Math.floor(mouseX), (int)Math.floor(mouseY))) >= 0 && this.parent instanceof ImportListMenu) {
            ImportListMenu menu = (ImportListMenu)this.parent;
            menu.openEditText(element);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private int getElementId(int mouseX, int mouseY) {
        if (mouseX > this.left + this.width - 8) {
            return -1;
        }
        int mouseListY = mouseY - this.top - this.getContentHeight() + (int)this.scrollDistance + 1;
        if (mouseListY < 0) {
            return Math.abs((int)Math.ceil(Math.abs(mouseListY) / this.entryHeight) - this.jsons.size() + 1);
        }
        return -1;
    }

    public void refresh(ArrayList<ImportedJsonObject> jsons) {
        this.jsons = jsons;
    }

    protected int getContentHeight() {
        return this.jsons.size() * this.entryHeight;
    }

    protected void drawPanel(int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        int hoverElement = -1;
        if (this.isMouseOver(mouseX, mouseY)) {
            hoverElement = this.getElementId(mouseX, mouseY);
        }
        boolean showScrollBar = this.getContentHeight() + 4 - this.height > 0;
        for (int i = 0; i < this.jsons.size(); ++i) {
            this.mc.func_110434_K().func_110577_a(TEXTURE);
            int startX = entryRight - this.width;
            int startY = relativeY + i * this.entryHeight - 3;
            this.blit(startX, startY, 0, i == hoverElement ? 160 + this.entryHeight : 160, 229, this.entryHeight);
            if (showScrollBar) {
                this.blit(startX + 229, startY, 229, i == hoverElement ? 160 + this.entryHeight : 160, 4, this.entryHeight);
            } else {
                this.blit(startX + 229, startY, 223, i == hoverElement ? 160 + this.entryHeight : 160, 10, this.entryHeight);
            }
            this.mc.field_71466_p.func_211126_b(this.jsons.get(i).getName(), (float)(startX + 46), (float)(startY + 5), 0x404040);
            if (this.jsons.get(i).hasGrid()) {
                this.mc.field_71466_p.func_211126_b("Grid: " + this.jsons.get(i).gridSize() + "x" + this.jsons.get(i).gridSize(), (float)(startX + 46), (float)(startY + 15), 0x404040);
            } else {
                this.mc.field_71466_p.func_211126_b("No Grid", (float)(startX + 46), (float)(startY + 15), 0x404040);
            }
            this.mc.field_71466_p.func_211126_b("Text Objects: " + this.jsons.get(i).getTextObjectCount(), (float)(startX + 145), (float)(startY + 15), 0x404040);
            this.mc.field_71466_p.func_211126_b("Artist: " + this.jsons.get(i).getArtist(), (float)(startX + 46), (float)(startY + 25), 0x404040);
            this.mc.field_71466_p.func_211126_b(this.jsons.get(i).getSource().equalsIgnoreCase("Game") ? "Made in-game" : "Made with Graffiti Editor", (float)(startX + 46), (float)(startY + 35), 0x404040);
            this.drawMiniGraffiti(this.jsons.get(i).getGrid(), startX + 8, startY + 8);
        }
    }

    private void drawMiniGraffiti(int[][] grid, int startX, int startY) {
        if (grid.length > 0) {
            for (int i = 0; i < grid.length; ++i) {
                for (int j = 0; j < grid[i].length; ++j) {
                    this.fillGradient(startX + j, startY + i, startX + j + 1, startY + i + 1, grid[j][i], grid[j][i]);
                }
            }
        }
    }
}

