/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.client.gui.widget;

import com.silvaniastudios.graffiti.client.gui.submenu.TextMenu;
import com.silvaniastudios.graffiti.drawables.TextDrawable;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.gui.ScrollPanel;

public class ListWidget
extends ScrollPanel {
    private final Minecraft mc;
    private static final ResourceLocation TEXTURE = new ResourceLocation("graffiti", "textures/gui/text_menu_list.png");
    private ArrayList<TextDrawable> texts;
    private int entryHeight;
    private Screen parent;

    public ListWidget(Minecraft client, int width, int height, int top, int left, int entryHeight, ArrayList<TextDrawable> texts, Screen parent) {
        super(client, width, height, top, left);
        this.mc = client;
        this.entryHeight = entryHeight;
        this.texts = texts;
        this.parent = parent;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int element;
        if (this.isMouseOver(mouseX, mouseY) && (element = this.getElementId((int)Math.floor(mouseX), (int)Math.floor(mouseY))) >= 0 && this.parent instanceof TextMenu) {
            TextMenu menu = (TextMenu)this.parent;
            menu.openEditText(element);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private int getElementId(int mouseX, int mouseY) {
        if (mouseX > this.left + this.width - 8) {
            return -1;
        }
        int mouseListY = mouseY - this.top - this.getContentHeight() + (int)this.scrollDistance + 1;
        if (mouseListY < 0) {
            return Math.abs((int)Math.ceil(Math.abs(mouseListY) / this.entryHeight) - this.texts.size() + 1);
        }
        return -1;
    }

    protected int getContentHeight() {
        return this.texts.size() * this.entryHeight;
    }

    protected void drawPanel(int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        int hoverElement = -1;
        if (this.isMouseOver(mouseX, mouseY)) {
            hoverElement = this.getElementId(mouseX, mouseY);
        }
        boolean showScrollBar = this.getContentHeight() + 4 - this.height > 0;
        for (int i = 0; i < this.texts.size(); ++i) {
            this.mc.func_110434_K().func_110577_a(TEXTURE);
            int startX = entryRight - this.width;
            int startY = relativeY + i * this.entryHeight - 3;
            this.blit(startX, startY, 0, i == hoverElement ? 100 + this.entryHeight : 100, 229, this.entryHeight);
            if (showScrollBar) {
                this.blit(startX + 229, startY, 229, i == hoverElement ? 100 + this.entryHeight : 100, 4, this.entryHeight);
            } else {
                this.blit(startX + 229, startY, 223, i == hoverElement ? 100 + this.entryHeight : 100, 10, this.entryHeight);
            }
            this.mc.field_71466_p.func_211126_b(this.texts.get(i).getDrawableText(), (float)(startX + 5), (float)(startY + 5), this.texts.get(i).getCol());
        }
    }
}

