/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.drawables;

import com.silvaniastudios.graffiti.drawables.PixelGridDrawable;
import com.silvaniastudios.graffiti.drawables.TextDrawable;
import com.silvaniastudios.graffiti.tileentity.TileEntityGraffiti;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;

public class CompleteGraffitiObject {
    String clickUrl = "";
    ItemStack backdropBlock;
    double alignmentOffset = 0.015625;
    int rightClickActionId;
    int backgroundTransparency = 200;
    Direction side;
    boolean offsetIntoBlock = true;
    public PixelGridDrawable pixelGrid;
    public ArrayList<TextDrawable> textList = new ArrayList();

    public CompleteGraffitiObject(Direction side, PixelGridDrawable grid, ArrayList<TextDrawable> text, ItemStack backdropBlock, int rightClickActionId, int backgroundTransparency, String clickUrl, double alignmentOffset, boolean offsetIntoBlock) {
        this.pixelGrid = grid;
        this.textList = text;
        this.backdropBlock = backdropBlock;
        this.rightClickActionId = rightClickActionId;
        this.backgroundTransparency = backgroundTransparency;
        this.clickUrl = clickUrl;
        this.alignmentOffset = alignmentOffset;
        this.offsetIntoBlock = offsetIntoBlock;
        this.side = side;
    }

    public CompleteGraffitiObject(Direction side, PixelGridDrawable grid, ArrayList<TextDrawable> text) {
        this(side, grid, text, null, 0, 200, "", 0.015625, true);
    }

    public boolean hasPixelGrid() {
        return this.pixelGrid != null && this.pixelGrid.size > 0;
    }

    public double getAlignment() {
        return this.alignmentOffset;
    }

    public boolean isOffsetIntoBlock() {
        return this.offsetIntoBlock;
    }

    public int getRightClickAction() {
        return this.rightClickActionId;
    }

    public void setRightClickAction(int id) {
        this.rightClickActionId = id;
    }

    public String getUrl() {
        return this.clickUrl;
    }

    public void setUrl(String url) {
        this.clickUrl = url;
    }

    public Direction getSide() {
        return this.side;
    }

    public void setBackgroundTransparency(int transparency) {
        this.backgroundTransparency = transparency;
    }

    public int getBackgroundTransparency() {
        return this.backgroundTransparency;
    }

    public void setAlignment(boolean offset, double offsetAmt, TileEntityGraffiti tile) {
        if (!tile.isLocked()) {
            this.alignmentOffset = offsetAmt;
            this.offsetIntoBlock = offset;
        }
    }

    public boolean writeText(TextDrawable text, TileEntityGraffiti tile) {
        if (!tile.isLocked()) {
            this.textList.add(text);
            return true;
        }
        return false;
    }

    public static void serializeNBT(CompoundNBT tag, CompleteGraffitiObject graffiti, String dirId) {
        System.out.println("serializing NBT on " + dirId);
        if (graffiti.textList != null) {
            System.out.println("text is not null");
        } else {
            System.out.println("text is null");
        }
        CompoundNBT nbt = new CompoundNBT();
        if (graffiti.pixelGrid != null) {
            PixelGridDrawable.serializeNBT(nbt, graffiti.pixelGrid);
        }
        if (graffiti.textList != null) {
            TextDrawable.serializeNBT(nbt, graffiti.textList);
        }
        nbt.func_74768_a("side", graffiti.side.func_176745_a());
        nbt.func_74780_a("alignmentOffset", graffiti.alignmentOffset);
        nbt.func_74757_a("offsetIntoBlock", graffiti.offsetIntoBlock);
        nbt.func_74768_a("rightClickActionID", graffiti.rightClickActionId);
        nbt.func_74768_a("backgroundTransparency", graffiti.backgroundTransparency);
        nbt.func_74778_a("url", graffiti.clickUrl);
        tag.func_218657_a("graffiti" + dirId, (INBT)nbt);
    }

    public static CompleteGraffitiObject deserializeNBT(CompoundNBT compound, String dirId) {
        CompoundNBT nbt = compound.func_74775_l("graffiti" + dirId);
        PixelGridDrawable pixelGrid = PixelGridDrawable.deserializeNBT(nbt);
        ArrayList<TextDrawable> textList = TextDrawable.deserializeNBT(nbt);
        int side = nbt.func_74762_e("side");
        ItemStack backdropBlock = null;
        int rightClickActionId = 0;
        int backgroundTransparency = 200;
        String clickUrl = "";
        double alignmentOffset = 0.015625;
        boolean offsetIntoBlock = true;
        if (nbt.func_74764_b("item")) {
            backdropBlock = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("item"));
        }
        if (nbt.func_74764_b("rightClickActionID")) {
            rightClickActionId = nbt.func_74762_e("rightClickActionID");
        }
        if (nbt.func_74764_b("backgroundTransparency")) {
            backgroundTransparency = nbt.func_74762_e("backgroundTransparency");
        }
        if (nbt.func_74764_b("url")) {
            clickUrl = nbt.func_74779_i("url");
        }
        if (nbt.func_74764_b("alignmentOffset")) {
            alignmentOffset = nbt.func_74769_h("alignmentOffset");
        }
        if (nbt.func_74764_b("offsetIntoBlock")) {
            offsetIntoBlock = nbt.func_74767_n("offsetIntoBlock");
        }
        return new CompleteGraffitiObject(Direction.func_82600_a((int)side), pixelGrid, textList, backdropBlock, rightClickActionId, backgroundTransparency, clickUrl, alignmentOffset, offsetIntoBlock);
    }
}

