/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.drawables;

import com.silvaniastudios.graffiti.drawables.DrawableBase;
import com.silvaniastudios.graffiti.tileentity.TileEntityGraffiti;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class PixelGridDrawable
extends DrawableBase {
    int size;
    int[][] pixelArray;
    int positionId = 0;
    double positionOffset = 0.0;
    int transparency = 255;

    public PixelGridDrawable(int size) {
        this.size = size;
        this.pixelArray = new int[size][size];
    }

    public PixelGridDrawable(int[][] grid) {
        this.size = grid.length;
        this.pixelArray = grid;
    }

    public int getSize() {
        return this.size;
    }

    public int[][] getPixelGrid() {
        return this.pixelArray;
    }

    public void setNewGrid(int size, int[][] grid) {
        this.size = size;
        this.pixelArray = grid;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public void setTransparency(int t) {
        this.transparency = t;
    }

    public void debugArray() {
        for (int i = 0; i < this.size; ++i) {
            String row = "";
            for (int j = 0; j < this.size; ++j) {
                row = this.pixelArray[j][i] != 0 ? row + "X" : row + " ";
            }
            System.out.println(row);
        }
    }

    public boolean setPixel(int x, int y, int col, TileEntityGraffiti te) {
        y = Math.abs(y - this.size);
        return this.setPixelRaw(x, y, col, te);
    }

    public boolean setPixelRaw(int x, int y, int col, TileEntityGraffiti te) {
        if (!te.isLocked()) {
            if (this.pixelArray.length != 0) {
                this.pixelArray[x][y] = col;
            }
            return true;
        }
        return false;
    }

    public boolean erasePixel(int x, int y, TileEntityGraffiti te) {
        return this.setPixel(x, y, 0, te);
    }

    public int getPixelRGB(int x, int y) {
        return this.pixelArray[x][y];
    }

    public static void serializeNBT(CompoundNBT nbt, PixelGridDrawable pixels) {
        if (pixels != null) {
            CompoundNBT gridnbt = new CompoundNBT();
            pixels.size = pixels.getPixelGrid().length;
            gridnbt.func_74768_a("size", pixels.size);
            gridnbt.func_74768_a("transparency", pixels.transparency);
            for (int i = 0; i < pixels.size; ++i) {
                gridnbt.func_74783_a("row_" + i, pixels.pixelArray[i]);
            }
            nbt.func_218657_a("pixel_grid", (INBT)gridnbt);
        } else {
            nbt.func_218657_a("pixel_grid", (INBT)new CompoundNBT());
        }
    }

    public static PixelGridDrawable deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("pixel_grid")) {
            CompoundNBT gridnbt = nbt.func_74775_l("pixel_grid");
            int size = gridnbt.func_74762_e("size");
            int transparency = 255;
            if (gridnbt.func_74764_b("transparency")) {
                transparency = gridnbt.func_74762_e("transparency");
            }
            int[][] arr = new int[size][size];
            for (int i = 0; i < size; ++i) {
                if (!gridnbt.func_74764_b("row_" + i)) continue;
                arr[i] = gridnbt.func_74759_k("row_" + i);
            }
            PixelGridDrawable drawable = new PixelGridDrawable(size);
            drawable.pixelArray = arr;
            drawable.setTransparency(transparency);
            return drawable;
        }
        return new PixelGridDrawable(16);
    }
}

