/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.drawables;

import com.silvaniastudios.graffiti.drawables.DrawableBase;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class TextDrawable
extends DrawableBase {
    private String text;
    private int colour;
    private short xPos;
    private short yPos;
    private float scale;
    private short rotation;
    private String format;
    private short alignment;

    public TextDrawable(String txt, short x, short y, int col, float scale, short rot, String format, short alignment) {
        this.text = txt;
        this.colour = col;
        this.xPos = x;
        this.yPos = y;
        this.scale = scale;
        this.rotation = rot;
        this.format = format;
        this.alignment = alignment;
    }

    public String getText() {
        return this.text;
    }

    public int getCol() {
        return this.colour;
    }

    public short xPos() {
        return this.xPos;
    }

    public short yPos() {
        return this.yPos;
    }

    public float scale() {
        return this.scale;
    }

    public short getRotation() {
        return this.rotation;
    }

    public String getFormat() {
        return this.format;
    }

    public short getAlignment() {
        return this.alignment;
    }

    public String getDrawableText() {
        return this.format + this.text;
    }

    public static CompoundNBT serializeNBT(CompoundNBT nbt, ArrayList<TextDrawable> textList) {
        ListNBT listnbt = new ListNBT();
        System.out.println("Serializing " + textList.size() + " texts");
        for (int i = 0; i < textList.size(); ++i) {
            TextDrawable t = textList.get(i);
            CompoundNBT textnbt = new CompoundNBT();
            textnbt.func_74778_a("text", t.text);
            textnbt.func_74768_a("colour", t.colour);
            textnbt.func_74777_a("xPos", t.xPos);
            textnbt.func_74777_a("yPos", t.yPos);
            textnbt.func_74776_a("scale", t.scale);
            textnbt.func_74777_a("rotation", t.rotation);
            textnbt.func_74778_a("format", t.format);
            textnbt.func_74777_a("alignment", t.alignment);
            listnbt.add((Object)textnbt);
        }
        nbt.func_218657_a("text_objects", (INBT)listnbt);
        return nbt;
    }

    public static ArrayList<TextDrawable> deserializeNBT(CompoundNBT nbt) {
        ArrayList<TextDrawable> textList = new ArrayList<TextDrawable>();
        if (nbt.func_74764_b("text_objects")) {
            ListNBT list = nbt.func_150295_c("text_objects", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT textnbt = list.func_150305_b(i);
                String text = textnbt.func_74779_i("text");
                int colour = textnbt.func_74762_e("colour");
                short xPos = textnbt.func_74765_d("xPos");
                short yPos = textnbt.func_74765_d("yPos");
                float scale = textnbt.func_74760_g("scale");
                short rot = textnbt.func_74765_d("rotation");
                String format = textnbt.func_74779_i("format");
                short alignment = textnbt.func_74765_d("alignment");
                textList.add(new TextDrawable(text, xPos, yPos, colour, scale, rot, format, alignment));
            }
        }
        return textList;
    }
}

