/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.items;

import com.silvaniastudios.graffiti.GraffitiBlocks;
import com.silvaniastudios.graffiti.block.GraffitiBlock;
import com.silvaniastudios.graffiti.client.gui.GuiWriteText;
import com.silvaniastudios.graffiti.drawables.CompleteGraffitiObject;
import com.silvaniastudios.graffiti.drawables.PixelGridDrawable;
import com.silvaniastudios.graffiti.drawables.TextDrawable;
import com.silvaniastudios.graffiti.items.DrawingItem;
import com.silvaniastudios.graffiti.tileentity.TileEntityGraffiti;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BasicPenItem
extends DrawingItem {
    Color col;

    public BasicPenItem(Item.Properties properties, Color col) {
        super(properties);
        this.col = col;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (handIn == Hand.MAIN_HAND) {
            ItemStack penIS = playerIn.func_184586_b(handIn);
            CompoundNBT tag = penIS.func_196082_o();
            BlockRayTraceResult result = this.rayTrace(worldIn, playerIn);
            if (playerIn.func_213453_ef() && result.func_216346_c().equals((Object)RayTraceResult.Type.MISS)) {
                boolean writingMode = tag.func_74767_n("writing");
                if (!worldIn.field_72995_K) {
                    playerIn.func_145747_a((ITextComponent)new StringTextComponent("Pen set to " + (writingMode ? "Drawing" : "Writing") + " mode"));
                }
                this.setWritingMode(penIS, !writingMode);
            }
        }
        return ActionResult.func_226250_c_((Object)playerIn.func_184586_b(handIn));
    }

    public void setWritingMode(ItemStack penIS, boolean writingMode) {
        CompoundNBT tag = penIS.func_196082_o();
        tag.func_74757_a("writing", writingMode);
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return this.onItemUseSensitive(context, Hand.MAIN_HAND);
    }

    public ActionResultType onItemUseSensitive(ItemUseContext context, Hand hand) {
        if (context.func_221531_n() != hand) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = context.func_195999_j().func_184586_b(hand);
        CompoundNBT nbt = stack.func_196082_o();
        if (!nbt.func_74764_b("colour")) {
            nbt.func_74768_a("colour", this.col.getRGB());
        }
        stack.func_77982_d(nbt);
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a().func_177972_a(context.func_196000_l());
        BlockPos clickedPos = context.func_195995_a();
        Block clickedBlock = world.func_180495_p(clickedPos).func_177230_c();
        if (!(clickedBlock instanceof GraffitiBlock)) {
            BlockState state = (BlockState)GraffitiBlocks.GRAFFITI.func_176223_P().func_206870_a((IProperty)GraffitiBlock.FACING, (Comparable)context.func_196000_l().func_176734_d());
            state = state.getStateForPlacement(context.func_196000_l(), state, (IWorld)world, pos, pos, hand);
            if (world.func_180495_p(pos).isAir((IBlockReader)world, pos)) {
                world.func_175656_a(pos, state);
                TileEntityGraffiti te = new TileEntityGraffiti();
                te.assignGraffiti(new CompleteGraffitiObject(context.func_196000_l().func_176734_d(), null, new ArrayList<TextDrawable>()), context.func_196000_l().func_176734_d());
                world.func_175690_a(pos, (TileEntity)te);
            } else if (world.func_180495_p(pos).func_177230_c() instanceof GraffitiBlock && world.func_175625_s(pos) instanceof TileEntityGraffiti) {
                TileEntityGraffiti te = (TileEntityGraffiti)world.func_175625_s(pos);
                if (te.getGraffitiForFace(context.func_196000_l().func_176734_d()) != null) {
                    return this.beginDraw(te, context, pos, stack);
                }
                te.assignGraffiti(new CompleteGraffitiObject(context.func_196000_l().func_176734_d(), null, new ArrayList<TextDrawable>()), context.func_196000_l().func_176734_d());
            }
            return ActionResultType.PASS;
        }
        if (world.func_175625_s(clickedPos) instanceof TileEntityGraffiti) {
            TileEntityGraffiti te = (TileEntityGraffiti)world.func_175625_s(clickedPos);
            return this.beginDraw(te, context, clickedPos, stack);
        }
        return ActionResultType.FAIL;
    }

    private ActionResultType beginDraw(TileEntityGraffiti te, ItemUseContext context, BlockPos pos, ItemStack stack) {
        CompleteGraffitiObject graffiti = te.getGraffitiForFace(context.func_196000_l().func_176734_d());
        if (graffiti == null) {
            graffiti = new CompleteGraffitiObject(context.func_196000_l().func_176734_d(), null, new ArrayList<TextDrawable>());
            te.assignGraffiti(graffiti, context.func_196000_l().func_176734_d());
        }
        int size = 64;
        int x = te.getVoxel(context.func_221532_j().field_72450_a - (double)pos.func_177958_n(), context.func_196000_l().func_176734_d(), 64);
        int y = te.getVoxel(context.func_221532_j().field_72448_b - (double)pos.func_177956_o(), null, 64);
        int z = te.getVoxel(context.func_221532_j().field_72449_c - (double)pos.func_177952_p(), context.func_196000_l().func_176734_d(), 64);
        boolean textMode = stack.func_77978_p().func_74767_n("writing");
        if (!(graffiti.pixelGrid != null && graffiti.pixelGrid.getSize() != 0 || textMode)) {
            graffiti.pixelGrid = new PixelGridDrawable(16);
            te.update();
        }
        if (!textMode && graffiti.pixelGrid.getSize() != 64) {
            size = graffiti.pixelGrid.getSize();
            x = te.getVoxel(context.func_221532_j().field_72450_a - (double)pos.func_177958_n(), context.func_196000_l().func_176734_d(), graffiti.pixelGrid.getSize());
            y = te.getVoxel(context.func_221532_j().field_72448_b - (double)pos.func_177956_o(), null, graffiti.pixelGrid.getSize());
            z = te.getVoxel(context.func_221532_j().field_72449_c - (double)pos.func_177952_p(), context.func_196000_l().func_176734_d(), graffiti.pixelGrid.getSize());
        }
        Color colour = new Color(stack.func_77978_p().func_74762_e("colour"));
        if (context.func_196000_l().func_176734_d() == Direction.NORTH) {
            this.processDrawingAction(te, graffiti, x, y, colour, textMode, 0, stack);
            return ActionResultType.PASS;
        }
        if (context.func_196000_l().func_176734_d() == Direction.EAST) {
            this.processDrawingAction(te, graffiti, z, y, colour, textMode, 0, stack);
            return ActionResultType.PASS;
        }
        if (context.func_196000_l().func_176734_d() == Direction.SOUTH) {
            this.processDrawingAction(te, graffiti, Math.abs(x - size), y, colour, textMode, 0, stack);
            return ActionResultType.PASS;
        }
        if (context.func_196000_l().func_176734_d() == Direction.WEST) {
            this.processDrawingAction(te, graffiti, Math.abs(z - size), y, colour, textMode, 0, stack);
            return ActionResultType.PASS;
        }
        Direction d = context.func_195992_f();
        if (context.func_196000_l().func_176734_d() == Direction.UP) {
            int rot = 0;
            if (d == Direction.NORTH) {
                rot = 180;
            }
            if (d == Direction.EAST) {
                rot = 90;
            }
            if (d == Direction.WEST) {
                rot = 270;
            }
            this.processDrawingAction(te, graffiti, x - 1, z, colour, textMode, rot, stack);
            return ActionResultType.PASS;
        }
        if (context.func_196000_l().func_176734_d() == Direction.DOWN) {
            int rot = 0;
            if (d == Direction.EAST) {
                rot = 270;
            }
            if (d == Direction.SOUTH) {
                rot = 180;
            }
            if (d == Direction.WEST) {
                rot = 90;
            }
            this.processDrawingAction(te, graffiti, Math.abs(x - size), z, colour, textMode, rot, stack);
            return ActionResultType.PASS;
        }
        return ActionResultType.FAIL;
    }

    private void processDrawingAction(TileEntityGraffiti te, CompleteGraffitiObject graffiti, int x, int y, Color col, boolean textMode, int rotation, ItemStack stack) {
        if (textMode) {
            if (te.func_145831_w().field_72995_K) {
                this.openWritingGui(te, graffiti, x, y, col, rotation, stack);
            }
        } else {
            graffiti.pixelGrid.setPixel(x, y, col.getRGB(), te);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openWritingGui(TileEntityGraffiti te, CompleteGraffitiObject graffiti, int x, int y, Color col, int rotation, ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147108_a((Screen)new GuiWriteText(te, graffiti, x, y, this.getColor(stack).getRGB(), rotation));
    }

    public BlockRayTraceResult rayTrace(World worldIn, PlayerEntity player) {
        return (BlockRayTraceResult)BasicPenItem.func_219968_a((World)worldIn, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
    }

    public Color getColorRaw() {
        return this.col;
    }

    public Color getColor(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("colour")) {
            return new Color(nbt.func_74762_e("colour"));
        }
        if (this.col != null) {
            nbt.func_74768_a("colour", this.col.getRGB());
            stack.func_77982_d(nbt);
            return this.col;
        }
        return Color.WHITE;
    }

    public String getHexColour(Color colour) {
        return String.format("#%02X%02X%02X", colour.getRed(), colour.getGreen(), colour.getBlue());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("Allows writing and drawing on the walls"));
        tooltip.add((ITextComponent)new StringTextComponent("Sneak-rightclick in open air to switch modes"));
        tooltip.add((ITextComponent)new StringTextComponent(""));
        if (stack.func_77942_o()) {
            tooltip.add((ITextComponent)new StringTextComponent("Current mode: " + (stack.func_77978_p().func_74767_n("writing") ? "Writing" : "Drawing")));
        }
        tooltip.add((ITextComponent)new StringTextComponent("Color: " + this.getHexColour(this.getColor(stack))));
    }
}

