/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.items;

import com.silvaniastudios.graffiti.client.gui.GuiColourPicker;
import com.silvaniastudios.graffiti.items.BasicPenItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MagicPenItem
extends BasicPenItem {
    int[] customColours = new int[21];

    public MagicPenItem(Item.Properties properties) {
        super(properties, null);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (handIn == Hand.MAIN_HAND) {
            BlockRayTraceResult result = this.rayTrace(worldIn, playerIn);
            if (playerIn.func_213453_ef() && result.func_216346_c().equals((Object)RayTraceResult.Type.MISS) && worldIn.field_72995_K) {
                this.processClientRightClick(playerIn.func_184586_b(handIn));
            }
        }
        return ActionResult.func_226250_c_((Object)playerIn.func_184586_b(handIn));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processClientRightClick(ItemStack item) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147108_a((Screen)new GuiColourPicker(item));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("Allows writing and drawing on the walls"));
        tooltip.add((ITextComponent)new StringTextComponent("Supports full RGB colour options!"));
        tooltip.add((ITextComponent)new StringTextComponent("Sneak-rightclick in open air to open colour picker"));
        tooltip.add((ITextComponent)new StringTextComponent(""));
        if (stack.func_77942_o()) {
            tooltip.add((ITextComponent)new StringTextComponent("Current mode: " + (stack.func_77978_p().func_74767_n("writing") ? "Writing" : "Drawing")));
        }
        tooltip.add((ITextComponent)new StringTextComponent("Color: " + this.getHexColour(this.getColor(stack))));
    }

    public int[] getCustomColours(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("customColours")) {
            return nbt.func_74759_k("customColours");
        }
        return new int[21];
    }

    public void setCustomColour(ItemStack stack, int col, int slot) {
        CompoundNBT nbt = stack.func_196082_o();
        int[] colours = new int[21];
        if (nbt.func_74764_b("customColours")) {
            colours = nbt.func_74759_k("customColours");
        }
        if (slot < colours.length) {
            colours[slot] = col;
        }
        nbt.func_74783_a("customColours", colours);
    }

    public void setPenColour(ItemStack stack, int col) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74768_a("colour", col);
    }
}

