/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.network;

import com.silvaniastudios.graffiti.tileentity.ContainerGraffiti;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class LockEditPacket {
    boolean locked;

    public LockEditPacket(boolean lockStatus) {
        this.locked = lockStatus;
    }

    public static void encode(LockEditPacket pkt, PacketBuffer buf) {
        buf.writeBoolean(pkt.locked);
    }

    public static LockEditPacket decode(PacketBuffer buf) {
        return new LockEditPacket(buf.readBoolean());
    }

    public static class Handler {
        public static void handle(LockEditPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                Container ctr = player.field_71070_bA;
                if (ctr instanceof ContainerGraffiti) {
                    ContainerGraffiti container = (ContainerGraffiti)ctr;
                    container.te.toggleLocked(msg.locked, (PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender());
                    container.te.update();
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

