/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.network;

import com.silvaniastudios.graffiti.items.MagicPenItem;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class PenCustomColourPacket {
    int colour;
    int slot;

    public PenCustomColourPacket(int colour, int slot) {
        this.colour = colour;
        this.slot = slot;
    }

    public static void encode(PenCustomColourPacket pkt, PacketBuffer buf) {
        buf.writeInt(pkt.colour);
        buf.writeInt(pkt.slot);
    }

    public static PenCustomColourPacket decode(PacketBuffer buf) {
        return new PenCustomColourPacket(buf.readInt(), buf.readInt());
    }

    public static class Handler {
        public static void handle(PenCustomColourPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                ItemStack held = player.func_184586_b(Hand.MAIN_HAND);
                if (held.func_77973_b() instanceof MagicPenItem) {
                    MagicPenItem pen = (MagicPenItem)held.func_77973_b();
                    pen.setCustomColour(held, msg.colour, msg.slot);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

