/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.network;

import com.silvaniastudios.graffiti.items.MagicPenItem;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetPenColourPacket {
    int colour;
    boolean writing;

    public SetPenColourPacket(int colour, boolean writing) {
        this.colour = colour;
        this.writing = writing;
    }

    public static void encode(SetPenColourPacket pkt, PacketBuffer buf) {
        buf.writeInt(pkt.colour);
        buf.writeBoolean(pkt.writing);
    }

    public static SetPenColourPacket decode(PacketBuffer buf) {
        return new SetPenColourPacket(buf.readInt(), buf.readBoolean());
    }

    public static class Handler {
        public static void handle(SetPenColourPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                ItemStack held = player.func_184586_b(Hand.MAIN_HAND);
                if (held.func_77973_b() instanceof MagicPenItem) {
                    MagicPenItem pen = (MagicPenItem)held.func_77973_b();
                    pen.setPenColour(held, msg.colour);
                    pen.setWritingMode(held, msg.writing);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

