/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.network;

import com.silvaniastudios.graffiti.tileentity.ContainerGraffiti;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetPositionPacket {
    boolean blockAligned;
    double offset;

    public SetPositionPacket(boolean blockAligned, double offset) {
        this.blockAligned = blockAligned;
        this.offset = offset;
    }

    public static void encode(SetPositionPacket pkt, PacketBuffer buf) {
        buf.writeBoolean(pkt.blockAligned);
        buf.writeDouble(pkt.offset);
    }

    public static SetPositionPacket decode(PacketBuffer buf) {
        return new SetPositionPacket(buf.readBoolean(), buf.readDouble());
    }

    public static class Handler {
        public static void handle(SetPositionPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                Container ctr = player.field_71070_bA;
                if (ctr instanceof ContainerGraffiti) {
                    ContainerGraffiti container = (ContainerGraffiti)ctr;
                    if (msg.offset >= -0.25 && msg.offset <= 0.25) {
                        container.graffiti.setAlignment(msg.blockAligned, msg.offset, container.te);
                        container.te.update();
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

