/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.network;

import com.silvaniastudios.graffiti.drawables.CompleteGraffitiObject;
import com.silvaniastudios.graffiti.drawables.TextDrawable;
import com.silvaniastudios.graffiti.tileentity.TileEntityGraffiti;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class WriteTextFromPenPacket {
    String text;
    BlockPos pos;
    short posX;
    short posY;
    float scale;
    int col;
    short rot;
    String format;
    short alignment;
    int editId;
    boolean delete;
    int side;

    public WriteTextFromPenPacket(String text, BlockPos pos, short x, short y, float scale, int col, short rot, String format, short alignment, int side) {
        this.text = text;
        this.pos = pos;
        this.posX = x;
        this.posY = y;
        this.scale = scale;
        this.col = col;
        this.rot = rot;
        this.format = format;
        this.alignment = alignment;
        this.side = side;
    }

    public static void encode(WriteTextFromPenPacket pkt, PacketBuffer buf) {
        buf.func_180714_a(pkt.text);
        buf.func_179255_a(pkt.pos);
        buf.writeShort((int)pkt.posX);
        buf.writeShort((int)pkt.posY);
        buf.writeFloat(pkt.scale);
        buf.writeInt(pkt.col);
        buf.writeShort((int)pkt.rot);
        buf.func_180714_a(pkt.format);
        buf.writeShort((int)pkt.alignment);
        buf.writeInt(pkt.side);
    }

    public static WriteTextFromPenPacket decode(PacketBuffer buf) {
        return new WriteTextFromPenPacket(buf.func_150789_c(50), buf.func_179259_c(), buf.readShort(), buf.readShort(), buf.readFloat(), buf.readInt(), buf.readShort(), buf.func_150789_c(10), buf.readShort(), buf.readInt());
    }

    public static class Handler {
        public static void handle(WriteTextFromPenPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                World world = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p;
                BlockPos pos = msg.pos;
                Direction side = Direction.func_82600_a((int)msg.side);
                if (world.func_175625_s(pos) instanceof TileEntityGraffiti) {
                    TileEntityGraffiti te = (TileEntityGraffiti)world.func_175625_s(pos);
                    CompleteGraffitiObject graffiti = te.getGraffitiForFace(side);
                    if (graffiti == null) {
                        graffiti = new CompleteGraffitiObject(side, null, new ArrayList<TextDrawable>());
                        te.assignGraffiti(graffiti, side);
                    }
                    graffiti.writeText(new TextDrawable(msg.text, msg.posX, msg.posY, msg.col, msg.scale, msg.rot, msg.format, msg.alignment), te);
                    te.update();
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

