/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.network;

import com.silvaniastudios.graffiti.drawables.CompleteGraffitiObject;
import com.silvaniastudios.graffiti.drawables.TextDrawable;
import com.silvaniastudios.graffiti.tileentity.ContainerGraffiti;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class WriteTextPacket {
    String text;
    short posX;
    short posY;
    float scale;
    int col;
    short rot;
    String format;
    short alignment;
    short editId;
    boolean delete;

    public WriteTextPacket(String text, short x, short y, float scale, int col, short rot, String format, short alignment, short editId, boolean delete) {
        this.text = text;
        this.posX = x;
        this.posY = y;
        this.scale = scale;
        this.col = col;
        this.rot = rot;
        this.format = format;
        this.alignment = alignment;
        this.editId = editId;
        this.delete = delete;
    }

    public WriteTextPacket(String text, short x, short y, float scale, int col, short rot, String format, short alignment) {
        this(text, x, y, scale, col, rot, format, alignment, -1, false);
    }

    public static void encode(WriteTextPacket pkt, PacketBuffer buf) {
        buf.func_180714_a(pkt.text);
        buf.writeShort((int)pkt.posX);
        buf.writeShort((int)pkt.posY);
        buf.writeFloat(pkt.scale);
        buf.writeInt(pkt.col);
        buf.writeShort((int)pkt.rot);
        buf.func_180714_a(pkt.format);
        buf.writeShort((int)pkt.alignment);
        buf.writeShort((int)pkt.editId);
        buf.writeBoolean(pkt.delete);
    }

    public static WriteTextPacket decode(PacketBuffer buf) {
        return new WriteTextPacket(buf.func_150789_c(50), buf.readShort(), buf.readShort(), buf.readFloat(), buf.readInt(), buf.readShort(), buf.func_150789_c(10), buf.readShort(), buf.readShort(), buf.readBoolean());
    }

    public static class Handler {
        public static void handle(WriteTextPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                Container ctr = player.field_71070_bA;
                if (ctr instanceof ContainerGraffiti) {
                    ContainerGraffiti container = (ContainerGraffiti)ctr;
                    if (msg.editId >= 0 && msg.editId <= container.graffiti.textList.size()) {
                        container.graffiti.textList.remove(msg.editId);
                        container.te.update();
                    }
                    if (!msg.delete) {
                        System.out.println("Text successfully received: " + msg.text);
                        CompleteGraffitiObject g = container.te.getGraffitiForFace(container.graffiti.getSide());
                        g.writeText(new TextDrawable(msg.text, msg.posX, msg.posY, msg.col, msg.scale, msg.rot, msg.format, msg.alignment), container.te);
                        container.te.update();
                        container.graffiti = container.te.getGraffitiForFace(container.graffiti.getSide());
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

