/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.tileentity;

import com.silvaniastudios.graffiti.drawables.CompleteGraffitiObject;
import com.silvaniastudios.graffiti.drawables.PixelGridDrawable;
import com.silvaniastudios.graffiti.drawables.TextDrawable;
import com.silvaniastudios.graffiti.tileentity.ContainerGraffiti;
import com.silvaniastudios.graffiti.tileentity.GraffitiTileEntityTypes;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TileEntityGraffiti
extends TileEntity
implements INamedContainerProvider {
    CompleteGraffitiObject graffiti_n;
    CompleteGraffitiObject graffiti_e;
    CompleteGraffitiObject graffiti_s;
    CompleteGraffitiObject graffiti_w;
    CompleteGraffitiObject graffiti_u;
    CompleteGraffitiObject graffiti_d;
    boolean locked = false;
    String lockedUuid = "";
    PixelGridDrawable oldGrid;
    ArrayList<TextDrawable> oldTexts;

    public TileEntityGraffiti() {
        super(GraffitiTileEntityTypes.GRAFFITI);
    }

    public void update() {
        this.sendUpdates();
    }

    public int getVoxel(double coordinate, Direction d, int size) {
        if (d == Direction.NORTH || d == Direction.EAST) {
            return (int)Math.ceil(coordinate * (double)size) - 1;
        }
        return (int)Math.ceil(coordinate * (double)size);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void toggleLocked(boolean lock, PlayerEntity player) {
        if (!this.locked && lock) {
            this.locked = true;
            this.lockedUuid = player.func_189512_bd();
            player.func_145747_a((ITextComponent)new StringTextComponent("Editing locked"));
        }
        if (this.locked && !lock && player.func_189512_bd().equalsIgnoreCase(this.lockedUuid)) {
            this.locked = false;
            this.lockedUuid = "";
            player.func_145747_a((ITextComponent)new StringTextComponent("Editing unlocked"));
        }
    }

    public CompleteGraffitiObject getGraffitiForFace(Direction d) {
        if (d == Direction.NORTH) {
            return this.graffiti_n;
        }
        if (d == Direction.EAST) {
            return this.graffiti_e;
        }
        if (d == Direction.SOUTH) {
            return this.graffiti_s;
        }
        if (d == Direction.WEST) {
            return this.graffiti_w;
        }
        if (d == Direction.DOWN) {
            return this.graffiti_d;
        }
        return this.graffiti_u;
    }

    public void assignGraffiti(CompleteGraffitiObject graffiti, Direction d) {
        System.out.println("Completely overriding graffiti on " + d.func_176610_l() + " and it has this many texts: " + graffiti.textList.size());
        if (d == Direction.NORTH) {
            this.graffiti_n = graffiti;
        }
        if (d == Direction.EAST) {
            this.graffiti_e = graffiti;
        }
        if (d == Direction.SOUTH) {
            this.graffiti_s = graffiti;
        }
        if (d == Direction.WEST) {
            this.graffiti_w = graffiti;
        }
        if (d == Direction.DOWN) {
            this.graffiti_d = graffiti;
        }
        if (d == Direction.UP) {
            this.graffiti_u = graffiti;
        }
        this.sendUpdates();
    }

    public boolean doesGraffitiExist() {
        for (Direction dir : Direction.values()) {
            if (this.getGraffitiForFace(dir) == null) continue;
            return true;
        }
        return false;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.graffiti_n != null) {
            CompleteGraffitiObject.serializeNBT(compound, this.graffiti_n, "_n");
        } else {
            compound.func_82580_o("graffiti_n");
        }
        if (this.graffiti_e != null) {
            CompleteGraffitiObject.serializeNBT(compound, this.graffiti_e, "_e");
        } else {
            compound.func_82580_o("graffiti_e");
        }
        if (this.graffiti_s != null) {
            CompleteGraffitiObject.serializeNBT(compound, this.graffiti_s, "_s");
        } else {
            compound.func_82580_o("graffiti_s");
        }
        if (this.graffiti_w != null) {
            CompleteGraffitiObject.serializeNBT(compound, this.graffiti_w, "_w");
        } else {
            compound.func_82580_o("graffiti_w");
        }
        if (this.graffiti_u != null) {
            CompleteGraffitiObject.serializeNBT(compound, this.graffiti_u, "_u");
        } else {
            compound.func_82580_o("graffiti_u");
        }
        if (this.graffiti_d != null) {
            CompleteGraffitiObject.serializeNBT(compound, this.graffiti_d, "_d");
        } else {
            compound.func_82580_o("graffiti_d");
        }
        if (this.oldGrid != null || this.oldTexts != null) {
            System.out.println("Old Graffiti data has been loaded. Now attempting to update to new format.");
            if (this.updateData(this.oldGrid, this.oldTexts, compound)) {
                this.oldGrid = null;
                this.oldTexts = null;
            }
        }
        compound.func_74757_a("locked", this.locked);
        compound.func_74778_a("lockedUuid", this.lockedUuid);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(CompoundNBT compound) {
        if (compound.func_74764_b("pixel_grid") || compound.func_74764_b("text_objects")) {
            System.out.println("Loading old data, this will be updated next save cycle.");
            this.oldGrid = PixelGridDrawable.deserializeNBT(compound);
            this.oldTexts = TextDrawable.deserializeNBT(compound);
        }
        if (compound.func_74764_b("graffiti_n")) {
            this.graffiti_n = CompleteGraffitiObject.deserializeNBT(compound, "_n");
        }
        if (compound.func_74764_b("graffiti_e")) {
            this.graffiti_e = CompleteGraffitiObject.deserializeNBT(compound, "_e");
        }
        if (compound.func_74764_b("graffiti_s")) {
            this.graffiti_s = CompleteGraffitiObject.deserializeNBT(compound, "_s");
        }
        if (compound.func_74764_b("graffiti_w")) {
            this.graffiti_w = CompleteGraffitiObject.deserializeNBT(compound, "_w");
        }
        if (compound.func_74764_b("graffiti_u")) {
            this.graffiti_u = CompleteGraffitiObject.deserializeNBT(compound, "_u");
        }
        if (compound.func_74764_b("graffiti_d")) {
            this.graffiti_d = CompleteGraffitiObject.deserializeNBT(compound, "_d");
        }
        this.locked = compound.func_74767_n("locked");
        this.lockedUuid = compound.func_74779_i("lockedUuid");
        super.func_145839_a(compound);
    }

    public boolean updateData(PixelGridDrawable grid, ArrayList<TextDrawable> text, CompoundNBT compound) {
        Direction facing = (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        if (text == null) {
            text = new ArrayList();
        }
        CompleteGraffitiObject graffiti = new CompleteGraffitiObject(facing, grid, text);
        System.out.printf("[GRAFFITI] Updating old graffiti data at %s, %s, %s (facing %s)\n", this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), facing);
        if (facing == Direction.NORTH) {
            this.graffiti_n = graffiti;
        }
        if (facing == Direction.EAST) {
            this.graffiti_e = graffiti;
        }
        if (facing == Direction.SOUTH) {
            this.graffiti_s = graffiti;
        }
        if (facing == Direction.WEST) {
            this.graffiti_w = graffiti;
        }
        if (facing == Direction.UP) {
            this.graffiti_u = graffiti;
        }
        if (facing == Direction.DOWN) {
            this.graffiti_d = graffiti;
        }
        compound.func_82580_o("pixel_grid");
        compound.func_82580_o("text_objects");
        this.update();
        return true;
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        BlockRayTraceResult result = this.rayTrace(this.field_145850_b, player);
        if (!result.func_216346_c().equals((Object)RayTraceResult.Type.MISS)) {
            return new ContainerGraffiti(id, inv, this, result.func_216354_b().func_176734_d().func_176745_a());
        }
        return new ContainerGraffiti(id, inv, this, 0);
    }

    protected BlockRayTraceResult rayTrace(World worldIn, PlayerEntity player) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vec3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
    }

    public BlockState getState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public boolean isLoaded() {
        return this.func_145830_o() && this.hasPosition() ? this.func_145831_w().func_175667_e(this.func_174877_v()) : false;
    }

    public boolean hasPosition() {
        return this.field_174879_c != null && this.field_174879_c != BlockPos.field_177992_a;
    }

    public void sendUpdates() {
        this.func_70296_d();
        if (this.isLoaded()) {
            BlockState state = this.getState();
            this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
        this.func_145831_w().func_184138_a(this.field_174879_c, this.getState(), this.getState(), 3);
    }

    public ItemStack getBackdropBlock() {
        return new ItemStack((IItemProvider)Blocks.field_150347_e);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.graffiti", new Object[0]);
    }
}

