/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.silvaniastudios.graffiti.drawables.CompleteGraffitiObject;
import com.silvaniastudios.graffiti.drawables.TextDrawable;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

public class FileExport {
    public static final int JSON_VERSION = 2;

    public static StringTextComponent createFile(String fileName, CompleteGraffitiObject graffiti, String playerName) {
        int i;
        File dir = new File("./graffiti/");
        if (!dir.exists()) {
            dir.mkdir();
        }
        int[][] grid = graffiti.pixelGrid.getPixelGrid();
        JsonArray gridArray = new JsonArray();
        JsonArray textObjectArray = new JsonArray();
        JsonArray drawableArray = new JsonArray();
        for (i = 0; i < grid.length; ++i) {
            JsonArray subArray = new JsonArray();
            for (int j = 0; j < grid.length; ++j) {
                subArray.add((Number)grid[j][i]);
            }
            gridArray.add((JsonElement)subArray);
        }
        for (i = 0; i < graffiti.textList.size(); ++i) {
            TextDrawable text = graffiti.textList.get(i);
            JsonObject textObject = new JsonObject();
            textObject.add("text", (JsonElement)new JsonPrimitive(text.getText()));
            textObject.add("colour", (JsonElement)new JsonPrimitive((Number)text.getCol()));
            textObject.add("posX", (JsonElement)new JsonPrimitive((Number)text.xPos()));
            textObject.add("posY", (JsonElement)new JsonPrimitive((Number)text.yPos()));
            textObject.add("scale", (JsonElement)new JsonPrimitive((Number)Float.valueOf(text.scale())));
            textObject.add("rotation", (JsonElement)new JsonPrimitive((Number)text.getRotation()));
            textObject.add("format", (JsonElement)new JsonPrimitive(text.getFormat()));
            textObject.add("alignment", (JsonElement)new JsonPrimitive((Number)text.getAlignment()));
            textObjectArray.add((JsonElement)textObject);
        }
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            FileWriter writer = new FileWriter("./graffiti/" + fileName + ".json");
            JsonObject json = new JsonObject();
            json.add("json_version", (JsonElement)new JsonPrimitive((Number)2));
            json.add("mod_version", (JsonElement)new JsonPrimitive(FileExport.getModVersion()));
            json.add("source", (JsonElement)new JsonPrimitive("Game"));
            json.add("artist", (JsonElement)new JsonPrimitive(playerName));
            json.add("offset", (JsonElement)new JsonPrimitive(Boolean.valueOf(graffiti.isOffsetIntoBlock())));
            json.add("offset_amount", (JsonElement)new JsonPrimitive((Number)graffiti.getAlignment()));
            json.add("texts", (JsonElement)textObjectArray);
            json.add("drawables", (JsonElement)drawableArray);
            json.add("grid_transparency", (JsonElement)new JsonPrimitive((Number)graffiti.pixelGrid.getTransparency()));
            json.add("grid_scale", (JsonElement)new JsonPrimitive((Number)graffiti.pixelGrid.getSize()));
            json.add("grid", (JsonElement)gridArray);
            gson.toJson((JsonElement)json, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new StringTextComponent("File export failed! See log for details.");
        }
        return new StringTextComponent("File \"" + fileName + ".json\" successfully exported");
    }

    public static String getModVersion() {
        List<ModInfo> mods = Collections.unmodifiableList(ModList.get().getMods());
        for (ModInfo mod : mods) {
            if (!mod.getModId().equalsIgnoreCase("graffiti")) continue;
            return mod.getVersion().toString();
        }
        return "ERROR: Version not found! This is a bug!";
    }
}

