/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class GraffitiUtils {
    public static int[][] increaseCanvasResized(int[][] canvasIn) {
        int originalSize = canvasIn.length;
        int newSize = 0;
        if (originalSize == 16) {
            newSize = 32;
        } else if (originalSize == 32) {
            newSize = 64;
        } else if (originalSize == 64) {
            newSize = 128;
        } else {
            return canvasIn;
        }
        int[][] newCanvas = new int[newSize][newSize];
        for (int i = 0; i < newSize; ++i) {
            for (int j = 0; j < newSize; ++j) {
                newCanvas[j][i] = canvasIn[j / 2][i / 2];
            }
        }
        return newCanvas;
    }

    public static int[][] increaseCanvasCropped(int[][] canvasIn) {
        int originalSize = canvasIn.length;
        int newSize = 0;
        if (originalSize == 16) {
            newSize = 32;
        } else if (originalSize == 32) {
            newSize = 64;
        } else if (originalSize == 64) {
            newSize = 128;
        } else {
            return canvasIn;
        }
        int[][] newCanvas = new int[newSize][newSize];
        for (int i = 0; i < newSize; ++i) {
            for (int j = 0; j < newSize; ++j) {
                boolean x = i < newSize / 2;
                boolean y = j < newSize / 2;
                newCanvas[j][i] = x && y ? canvasIn[j][i] : 0;
            }
        }
        return newCanvas;
    }

    public static int[][] decreaseCanvasCropped(int[][] canvasIn) {
        int originalSize = canvasIn.length;
        int newSize = 0;
        if (originalSize == 32) {
            newSize = 16;
        } else if (originalSize == 64) {
            newSize = 32;
        } else if (originalSize == 128) {
            newSize = 64;
        } else {
            return canvasIn;
        }
        int[][] newCanvas = new int[newSize][newSize];
        for (int i = 0; i < newSize; ++i) {
            for (int j = 0; j < newSize; ++j) {
                newCanvas[j][i] = canvasIn[j][i];
            }
        }
        return newCanvas;
    }

    public static int[][] decreaseCanvasResized(int[][] canvasIn) {
        int originalSize = canvasIn.length;
        int newSize = 0;
        if (originalSize == 32) {
            newSize = 16;
        } else if (originalSize == 64) {
            newSize = 32;
        } else if (originalSize == 128) {
            newSize = 64;
        } else {
            return canvasIn;
        }
        int[][] newCanvas = new int[newSize][newSize];
        for (int i = 0; i < newSize; ++i) {
            for (int j = 0; j < newSize; ++j) {
                newCanvas[j][i] = canvasIn[j * 2][i * 2];
            }
        }
        return newCanvas;
    }

    public static int[][] rescaleMultiple(int[][] canvasIn, int target, boolean rescale) {
        int[][] newCanvas;
        block3: {
            int resizeIterations;
            block2: {
                newCanvas = (int[][])canvasIn.clone();
                resizeIterations = GraffitiUtils.sizeToId(target) - GraffitiUtils.sizeToId(canvasIn.length);
                if (resizeIterations <= 0) break block2;
                for (int i = 0; i < resizeIterations; ++i) {
                    newCanvas = rescale ? GraffitiUtils.increaseCanvasResized(newCanvas) : GraffitiUtils.increaseCanvasCropped(newCanvas);
                }
                break block3;
            }
            if (resizeIterations >= 0) break block3;
            resizeIterations = Math.abs(resizeIterations);
            for (int i = 0; i < resizeIterations; ++i) {
                newCanvas = rescale ? GraffitiUtils.decreaseCanvasResized(newCanvas) : GraffitiUtils.decreaseCanvasCropped(newCanvas);
            }
        }
        return newCanvas;
    }

    public static int sizeToId(int size) {
        if (size == 16) {
            return 0;
        }
        if (size == 32) {
            return 1;
        }
        if (size == 64) {
            return 2;
        }
        if (size == 128) {
            return 3;
        }
        return -1;
    }

    public static int idToSize(int id) {
        if (id == 0) {
            return 16;
        }
        if (id == 1) {
            return 32;
        }
        if (id == 2) {
            return 64;
        }
        if (id == 3) {
            return 128;
        }
        return 0;
    }

    public static boolean hasBold(String str) {
        return str.contains("\u00a7l");
    }

    public static boolean hasItalic(String str) {
        return str.contains("\u00a7o");
    }

    public static boolean hasUnderline(String str) {
        return str.contains("\u00a7n");
    }

    public static boolean hasStrikethrough(String str) {
        return str.contains("\u00a7m");
    }

    public static String rightClickActionString(int id) {
        if (id == 0) {
            return "Click-Through";
        }
        if (id == 2) {
            return "Display Art";
        }
        if (id == 3) {
            return "Open URL";
        }
        return "No Action";
    }

    public int[][] rotateClockwise(int[][] gridIn) {
        int[][] gridOut = new int[gridIn.length][gridIn.length];
        for (int i = 0; i < gridIn.length; ++i) {
            for (int j = 0; j < gridIn.length; ++j) {
                gridOut[i][j] = gridIn[j][i];
            }
        }
        return gridOut;
    }

    public static BlockRayTraceResult rayTrace(World worldIn, PlayerEntity player) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vec3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        System.out.println("tracing");
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
    }
}

