/*
 * Decompiled with CFR 0.152.
 */
package net.mattbaker.guardscraft.guards;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.mattbaker.guardscraft.guards.HurtByTargetGoalGuard;
import net.mattbaker.guardscraft.guards.TemptGoalGuard;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.InteractDoorGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuardEntity
extends CreatureEntity {
    private int stateCurrentOrder = 0;
    protected String currentOrder = "Stay";
    protected String orderCombat = this.getStateOrderCombatString();
    private TemptGoalGuard objectTemptGoalGuard = new TemptGoalGuard((CreatureEntity)this, 1.0, false, Ingredient.field_193370_a);
    private static final DataParameter<Integer> stateOrderCombat = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> stateOrderCombatString = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> statePositionEtablishedX = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> statePositionEtablishedY = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> statePositionEtablishedZ = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private BlockPos positionCurrent;
    @Nullable
    protected Raid raid;
    private static final ResourceLocation DROP = new ResourceLocation("guardscraft", "loot_tables/entity/milician.json");

    protected GuardEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(stateOrderCombatString, (Object)"Order");
        this.field_70180_af.func_187214_a(stateOrderCombat, (Object)0);
        this.field_70180_af.func_187214_a(statePositionEtablishedX, (Object)0);
        this.field_70180_af.func_187214_a(statePositionEtablishedY, (Object)0);
        this.field_70180_af.func_187214_a(statePositionEtablishedZ, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new InteractDoorGoal((MobEntity)this){});
        this.field_70714_bg.func_75776_a(4, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, GuardEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.applyEntityAI();
    }

    protected void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoalGuard(this, new Class[0]).setCallsForHelp(GuardEntity.class));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, SlimeEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ShulkerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PhantomEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, false, false, predicate -> predicate instanceof IMob));
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void func_200203_b(ITextComponent name) {
        name = new StringTextComponent(this.currentOrder + " | " + this.orderCombat + " | Life : " + (int)this.func_110143_aJ());
        super.func_200203_b(name);
    }

    protected String getStateOrderCombatString() {
        return (String)this.field_70180_af.func_187225_a(stateOrderCombatString);
    }

    protected void setStateOrderCombatString(String newStateOrderCombatString) {
        this.field_70180_af.func_187227_b(stateOrderCombatString, (Object)newStateOrderCombatString);
    }

    protected int getStateOrderCombat() {
        return (Integer)this.field_70180_af.func_187225_a(stateOrderCombat);
    }

    protected void setStateOrderCombat(int newStateOrderCombat) {
        this.field_70180_af.func_187227_b(stateOrderCombat, (Object)newStateOrderCombat);
    }

    protected int[] getStatePositionEtablished() {
        int[] coordinatesPositionEtablished = new int[]{(Integer)this.field_70180_af.func_187225_a(statePositionEtablishedX), (Integer)this.field_70180_af.func_187225_a(statePositionEtablishedY), (Integer)this.field_70180_af.func_187225_a(statePositionEtablishedZ)};
        return coordinatesPositionEtablished;
    }

    protected void setStatePositionEtablished(int newStatePositionEtablishedX, int newStatePositionEtablishedY, int newStatePositionEtablishedZ) {
        this.field_70180_af.func_187227_b(statePositionEtablishedX, (Object)newStatePositionEtablishedX);
        this.field_70180_af.func_187227_b(statePositionEtablishedY, (Object)newStatePositionEtablishedY);
        this.field_70180_af.func_187227_b(statePositionEtablishedZ, (Object)newStatePositionEtablishedZ);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("stateOrderCombat", ((Integer)this.field_70180_af.func_187225_a(stateOrderCombat)).intValue());
        compound.func_74778_a("stateOrderCombatString", (String)this.field_70180_af.func_187225_a(stateOrderCombatString));
        compound.func_74768_a("statePositionEtablishedX", ((Integer)this.field_70180_af.func_187225_a(statePositionEtablishedX)).intValue());
        compound.func_74768_a("statePositionEtablishedY", ((Integer)this.field_70180_af.func_187225_a(statePositionEtablishedY)).intValue());
        compound.func_74768_a("statePositionEtablishedZ", ((Integer)this.field_70180_af.func_187225_a(statePositionEtablishedZ)).intValue());
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.field_70180_af.func_187227_b(stateOrderCombat, (Object)compound.func_74762_e("stateOrderCombat"));
        this.field_70180_af.func_187227_b(stateOrderCombatString, (Object)compound.func_74779_i("stateOrderCombatString"));
        this.field_70180_af.func_187227_b(statePositionEtablishedX, (Object)compound.func_74762_e("statePositionEtablishedX"));
        this.field_70180_af.func_187227_b(statePositionEtablishedY, (Object)compound.func_74762_e("statePositionEtablishedY"));
        this.field_70180_af.func_187227_b(statePositionEtablishedZ, (Object)compound.func_74762_e("statePositionEtablishedZ"));
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.func_180481_a(difficultyIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected boolean healthUnits(PlayerEntity playerIn, Hand handIn) {
        boolean food = false;
        ItemStack itemStack = playerIn.func_184586_b(handIn);
        food = itemStack.func_222117_E() && this.func_110143_aJ() < 50.0f;
        if (food) {
            playerIn.func_145747_a(ITextComponent.func_244388_a((String)"Regenerate yourself and heal your injuries with this ration."), playerIn.func_110124_au());
            this.func_195064_c(new EffectInstance(Effects.field_76428_l, 1000));
            playerIn.field_71071_by.func_70298_a(playerIn.field_71071_by.func_184429_b(itemStack), 1);
        }
        return food;
    }

    public ActionResultType func_184199_a(PlayerEntity playerIn, Vector3d vec, Hand handIn) {
        if (!this.field_70170_p.field_72995_K) {
            boolean food = this.healthUnits(playerIn, handIn);
            if (playerIn.func_213453_ef() && !food) {
                if (this.getStateOrderCombat() == 0) {
                    playerIn.func_145747_a(ITextComponent.func_244388_a((String)"Defend your position."), playerIn.func_110124_au());
                    this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
                    this.field_70180_af.func_187227_b(stateOrderCombatString, (Object)"Defensive");
                    this.func_200203_b((ITextComponent)new StringTextComponent((String)this.field_70180_af.func_187225_a(stateOrderCombatString)));
                    this.field_70180_af.func_187227_b(stateOrderCombat, (Object)1);
                    this.orderCombat = "Defensive";
                    this.func_200203_b((ITextComponent)new StringTextComponent(this.orderCombat));
                    this.field_70180_af.func_187227_b(statePositionEtablishedX, (Object)this.func_233580_cy_().func_177958_n());
                    this.field_70180_af.func_187227_b(statePositionEtablishedY, (Object)this.func_233580_cy_().func_177956_o());
                    this.field_70180_af.func_187227_b(statePositionEtablishedZ, (Object)this.func_233580_cy_().func_177952_p());
                    return ActionResultType.CONSUME;
                }
                if (this.getStateOrderCombat() == 1) {
                    playerIn.func_145747_a(ITextComponent.func_244388_a((String)"Attack enemies in your field of vision."), playerIn.func_110124_au());
                    this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.35);
                    this.field_70180_af.func_187227_b(stateOrderCombatString, (Object)"Offensive");
                    this.func_200203_b((ITextComponent)new StringTextComponent((String)this.field_70180_af.func_187225_a(stateOrderCombatString)));
                    this.field_70180_af.func_187227_b(stateOrderCombat, (Object)0);
                    this.orderCombat = "Offensive";
                    this.func_200203_b((ITextComponent)new StringTextComponent(this.orderCombat));
                    return ActionResultType.CONSUME;
                }
            } else if (!playerIn.func_213453_ef() && !food) {
                if (this.stateCurrentOrder == 0) {
                    playerIn.func_145747_a(ITextComponent.func_244388_a((String)"Follow me."), playerIn.func_110124_au());
                    this.field_70714_bg.func_75776_a(4, (Goal)this.objectTemptGoalGuard);
                    this.currentOrder = "Follow";
                    this.func_200203_b((ITextComponent)new StringTextComponent(this.currentOrder));
                    this.stateCurrentOrder = 1;
                    return ActionResultType.CONSUME;
                }
                if (this.stateCurrentOrder == 1) {
                    playerIn.func_145747_a(ITextComponent.func_244388_a((String)"Stay here."), playerIn.func_110124_au());
                    this.field_70714_bg.func_85156_a((Goal)this.objectTemptGoalGuard);
                    this.currentOrder = "Stay";
                    this.func_200203_b((ITextComponent)new StringTextComponent(this.currentOrder));
                    this.stateCurrentOrder = 0;
                    return ActionResultType.CONSUME;
                }
            }
        }
        return ActionResultType.CONSUME;
    }

    public void keepPosition() {
        if (this.getStateOrderCombat() == 1) {
            this.positionCurrent = this.func_233580_cy_();
            if (this.positionCurrent.func_177958_n() != ((Integer)this.field_70180_af.func_187225_a(statePositionEtablishedX)).intValue() || this.positionCurrent.func_177956_o() != ((Integer)this.field_70180_af.func_187225_a(statePositionEtablishedY)).intValue() || this.positionCurrent.func_177952_p() != ((Integer)this.field_70180_af.func_187225_a(statePositionEtablishedZ)).intValue()) {
                this.func_70107_b(((Integer)this.field_70180_af.func_187225_a(statePositionEtablishedX)).intValue(), ((Integer)this.field_70180_af.func_187225_a(statePositionEtablishedY)).intValue(), (Integer)this.field_70180_af.func_187225_a(statePositionEtablishedZ) + 1);
            }
        }
    }

    public void updateOrderCombat() {
        if (this.getStateOrderCombat() == 0) {
            this.orderCombat = "Offensive";
            this.func_200203_b((ITextComponent)new StringTextComponent(this.orderCombat));
        } else if (this.getStateOrderCombat() == 1) {
            this.orderCombat = "Defensive";
            this.func_200203_b((ITextComponent)new StringTextComponent(this.orderCombat));
        }
    }

    public void func_70636_d() {
        this.keepPosition();
        this.updateOrderCombat();
        this.func_82168_bl();
        this.swingTime();
        super.func_70636_d();
    }

    protected void swingTime() {
        float f = this.func_70013_c();
        if (f > 0.5f) {
            this.field_70708_bq += 2;
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        int i;
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        float f1 = (float)this.func_233637_b_(Attributes.field_233824_g_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entityIn).func_70668_bt());
            f1 += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
            entityIn.func_70015_d(i * 4);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_233627_a_(f1 * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)entityIn;
                this.func_233655_a_(playerentity, this.func_184614_ca(), playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a);
            }
            this.func_174815_a((LivingEntity)this, entityIn);
            this.func_130011_c(entityIn);
        }
        return flag;
    }

    private void func_233655_a_(PlayerEntity p_233655_1_, ItemStack p_233655_2_, ItemStack p_233655_3_) {
        if (!p_233655_2_.func_190926_b() && !p_233655_3_.func_190926_b() && p_233655_2_.func_77973_b() instanceof AxeItem && p_233655_3_.func_77973_b() == Items.field_185159_cQ) {
            float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
            if (this.field_70146_Z.nextFloat() < f) {
                p_233655_1_.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                this.field_70170_p.func_72960_a((Entity)p_233655_1_, (byte)30);
            }
        }
    }

    public ItemStack func_213356_f(ItemStack shootable) {
        if (shootable.func_77973_b() instanceof ShootableItem) {
            Predicate predicate = ((ShootableItem)shootable.func_77973_b()).func_220006_d();
            ItemStack itemstack = ShootableItem.func_220005_a((LivingEntity)this, (Predicate)predicate);
            return itemstack.func_190926_b() ? new ItemStack((IItemProvider)Items.field_151032_g) : itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ArmPose getArmPose() {
        return ArmPose.CROSSED;
    }

    @Nullable
    public Raid getRaid() {
        return this.raid;
    }

    public boolean isRaidActive() {
        return this.getRaid() != null && this.getRaid().func_221333_v();
    }

    protected ResourceLocation func_184647_J() {
        return DROP;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum ArmPose {
        CROSSED,
        ATTACKING,
        SPELLCASTING,
        BOW_AND_ARROW,
        CROSSBOW_HOLD,
        CROSSBOW_CHARGE,
        CELEBRATING,
        NEUTRAL;

    }
}

