/*
 * Decompiled with CFR 0.152.
 */
package net.mattbaker.guardscraft.guards.distance;

import javax.annotation.Nullable;
import net.mattbaker.guardscraft.guards.GuardEntity;
import net.mattbaker.guardscraft.guards.distance.RangedBowAttackGoalGuard;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public abstract class AbstractBowGuardEntity
extends GuardEntity
implements IRangedAttackMob {
    boolean firedArrow = false;
    CampfireBlock campfireBlock;
    AxisAlignedBB aabb = new AxisAlignedBB(1.0, 1.0, 1.0, 5.0, 5.0, 5.0);
    private final RangedBowAttackGoalGuard<AbstractBowGuardEntity> aiArrowAttack = new RangedBowAttackGoalGuard<AbstractBowGuardEntity>(this, 1.0, 20, 15.0f);
    private final MeleeAttackGoal aiAttackOnCollide = new MeleeAttackGoal(this, 1.2, false){

        public void func_75251_c() {
            super.func_75251_c();
            AbstractBowGuardEntity.this.func_213395_q(false);
        }

        public void func_75249_e() {
            super.func_75249_e();
            AbstractBowGuardEntity.this.func_213395_q(true);
        }
    };

    protected AbstractBowGuardEntity(EntityType<? extends AbstractBowGuardEntity> type, World worldIn) {
        super(type, worldIn);
        this.setCombatTask();
    }

    public static AttributeModifierMap.MutableAttribute func_234342_eQ_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 50.0);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_180481_a(difficultyIn);
        this.func_180483_b(difficultyIn);
        this.setCombatTask();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * difficultyIn.func_180170_c());
        return spawnDataIn;
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a(this.aiArrowAttack);
            ItemStack itemstack = this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f));
            if (itemstack.func_77973_b() instanceof BowItem) {
                int i = 20;
                if (this.field_70170_p.func_175659_aa() != Difficulty.HARD) {
                    i = 40;
                }
                this.aiArrowAttack.setAttackCooldown(i);
                this.field_70714_bg.func_75776_a(4, this.aiArrowAttack);
            }
        }
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f)));
        AbstractArrowEntity abstractarrowentity = this.fireArrow(itemstack, distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(abstractarrowentity);
        }
        if (this.firedArrow) {
            abstractarrowentity.func_70015_d(10);
        }
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - abstractarrowentity.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        abstractarrowentity.func_70186_c(d0, d1 + d3 * 0.15, d2, 2.5f, 0.0f);
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)abstractarrowentity);
    }

    protected AbstractArrowEntity fireArrow(ItemStack arrowStack, float distanceFactor) {
        return ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)arrowStack, (float)distanceFactor);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setCombatTask();
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K) {
            this.setCombatTask();
        }
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.74f;
    }

    public double func_70033_W() {
        return -0.6;
    }

    public boolean getDistanceWithPlayer(PlayerEntity playerIn) {
        return this.func_70032_d((Entity)playerIn) < 10.0f;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            // empty if block
        }
        super.func_70636_d();
    }
}

