/*
 * Decompiled with CFR 0.152.
 */
package net.mattbaker.guardscraft.guards.distance;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.mattbaker.guardscraft.guards.GuardEntity;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;

public class DistanceCrossbowGuardModel<T extends GuardEntity>
extends SegmentedModel<T>
implements IHasArm,
IHasHead {
    private final ModelRenderer head;
    private final ModelRenderer hat;
    private final ModelRenderer body;
    private final ModelRenderer arms;
    private final ModelRenderer field_217143_g;
    private final ModelRenderer field_217144_h;
    private final ModelRenderer rightArm;
    private final ModelRenderer leftArm;
    private float field_217145_m;

    public DistanceCrossbowGuardModel(float scaleFactor, float p_i47227_2_, int textureWidthIn, int textureHeightIn) {
        this.head = new ModelRenderer((Model)this).func_78787_b(textureWidthIn, textureHeightIn);
        this.head.func_78793_a(0.0f, 0.0f + p_i47227_2_, 0.0f);
        this.head.func_78784_a(0, 0).func_228301_a_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, scaleFactor);
        this.hat = new ModelRenderer((Model)this, 32, 0).func_78787_b(textureWidthIn, textureHeightIn);
        this.hat.func_228301_a_(-4.0f, -10.0f, -4.0f, 8.0f, 12.0f, 8.0f, scaleFactor + 0.45f);
        this.head.func_78792_a(this.hat);
        this.hat.field_78806_j = false;
        ModelRenderer modelrenderer = new ModelRenderer((Model)this).func_78787_b(textureWidthIn, textureHeightIn);
        modelrenderer.func_78793_a(0.0f, p_i47227_2_ - 2.0f, 0.0f);
        modelrenderer.func_78784_a(24, 0).func_228301_a_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, scaleFactor);
        this.head.func_78792_a(modelrenderer);
        this.body = new ModelRenderer((Model)this).func_78787_b(textureWidthIn, textureHeightIn);
        this.body.func_78793_a(0.0f, 0.0f + p_i47227_2_, 0.0f);
        this.body.func_78784_a(16, 20).func_228301_a_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, scaleFactor);
        this.body.func_78784_a(0, 38).func_228301_a_(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, scaleFactor + 0.5f);
        this.arms = new ModelRenderer((Model)this).func_78787_b(textureWidthIn, textureHeightIn);
        this.arms.func_78793_a(0.0f, 0.0f + p_i47227_2_ + 2.0f, 0.0f);
        this.arms.func_78784_a(44, 22).func_228301_a_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, scaleFactor);
        ModelRenderer modelrenderer1 = new ModelRenderer((Model)this, 44, 22).func_78787_b(textureWidthIn, textureHeightIn);
        modelrenderer1.field_78809_i = true;
        modelrenderer1.func_228301_a_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, scaleFactor);
        this.arms.func_78792_a(modelrenderer1);
        this.arms.func_78784_a(40, 38).func_228301_a_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, scaleFactor);
        this.field_217143_g = new ModelRenderer((Model)this, 0, 22).func_78787_b(textureWidthIn, textureHeightIn);
        this.field_217143_g.func_78793_a(-2.0f, 12.0f + p_i47227_2_, 0.0f);
        this.field_217143_g.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, scaleFactor);
        this.field_217144_h = new ModelRenderer((Model)this, 0, 22).func_78787_b(textureWidthIn, textureHeightIn);
        this.field_217144_h.field_78809_i = true;
        this.field_217144_h.func_78793_a(2.0f, 12.0f + p_i47227_2_, 0.0f);
        this.field_217144_h.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, scaleFactor);
        this.rightArm = new ModelRenderer((Model)this, 40, 46).func_78787_b(textureWidthIn, textureHeightIn);
        this.rightArm.func_228301_a_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, scaleFactor);
        this.rightArm.func_78793_a(-5.0f, 2.0f + p_i47227_2_, 0.0f);
        this.leftArm = new ModelRenderer((Model)this, 40, 46).func_78787_b(textureWidthIn, textureHeightIn);
        this.leftArm.field_78809_i = true;
        this.leftArm.func_228301_a_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, scaleFactor);
        this.leftArm.func_78793_a(5.0f, 2.0f + p_i47227_2_, 0.0f);
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.of((Object)this.head, (Object)this.body, (Object)this.field_217143_g, (Object)this.field_217144_h, (Object)this.arms, (Object)this.rightArm, (Object)this.leftArm);
    }

    public void setRotationAngles(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag;
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.arms.field_78797_d = 3.0f;
        this.arms.field_78798_e = -1.0f;
        this.arms.field_78795_f = -0.75f;
        if (this.field_217113_d) {
            this.rightArm.field_78795_f = -0.62831855f;
            this.rightArm.field_78796_g = 0.0f;
            this.rightArm.field_78808_h = 0.0f;
            this.leftArm.field_78795_f = -0.62831855f;
            this.leftArm.field_78796_g = 0.0f;
            this.leftArm.field_78808_h = 0.0f;
            this.field_217143_g.field_78795_f = -1.4137167f;
            this.field_217143_g.field_78796_g = 0.31415927f;
            this.field_217143_g.field_78808_h = 0.07853982f;
            this.field_217144_h.field_78795_f = -1.4137167f;
            this.field_217144_h.field_78796_g = -0.31415927f;
            this.field_217144_h.field_78808_h = -0.07853982f;
        } else {
            this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.rightArm.field_78796_g = 0.0f;
            this.rightArm.field_78808_h = 0.0f;
            this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.leftArm.field_78796_g = 0.0f;
            this.leftArm.field_78808_h = 0.0f;
            this.field_217143_g.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
            this.field_217143_g.field_78796_g = 0.0f;
            this.field_217143_g.field_78808_h = 0.0f;
            this.field_217144_h.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
            this.field_217144_h.field_78796_g = 0.0f;
            this.field_217144_h.field_78808_h = 0.0f;
        }
        GuardEntity.ArmPose GuardEntity$armpose = ((GuardEntity)((Object)entityIn)).getArmPose();
        if (GuardEntity$armpose == GuardEntity.ArmPose.ATTACKING) {
            float f = MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI));
            float f1 = MathHelper.func_76126_a((float)((1.0f - (1.0f - this.field_217112_c) * (1.0f - this.field_217112_c)) * (float)Math.PI));
            this.rightArm.field_78808_h = 0.0f;
            this.leftArm.field_78808_h = 0.0f;
            this.rightArm.field_78796_g = 0.15707964f;
            this.leftArm.field_78796_g = -0.15707964f;
            if (entityIn.func_184591_cq() == HandSide.RIGHT) {
                this.rightArm.field_78795_f = -1.8849558f + MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.15f;
                this.leftArm.field_78795_f = -0.0f + MathHelper.func_76134_b((float)(ageInTicks * 0.19f)) * 0.5f;
                this.rightArm.field_78795_f += f * 2.2f - f1 * 0.4f;
                this.leftArm.field_78795_f += f * 1.2f - f1 * 0.4f;
            } else {
                this.rightArm.field_78795_f = -0.0f + MathHelper.func_76134_b((float)(ageInTicks * 0.19f)) * 0.5f;
                this.leftArm.field_78795_f = -1.8849558f + MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.15f;
                this.rightArm.field_78795_f += f * 1.2f - f1 * 0.4f;
                this.leftArm.field_78795_f += f * 2.2f - f1 * 0.4f;
            }
            this.rightArm.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.leftArm.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.rightArm.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
            this.leftArm.field_78795_f -= MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
        } else if (GuardEntity$armpose == GuardEntity.ArmPose.SPELLCASTING) {
            this.rightArm.field_78798_e = 0.0f;
            this.rightArm.field_78800_c = -5.0f;
            this.leftArm.field_78798_e = 0.0f;
            this.leftArm.field_78800_c = 5.0f;
            this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.rightArm.field_78808_h = 2.3561945f;
            this.leftArm.field_78808_h = -2.3561945f;
            this.rightArm.field_78796_g = 0.0f;
            this.leftArm.field_78796_g = 0.0f;
        } else if (GuardEntity$armpose == GuardEntity.ArmPose.BOW_AND_ARROW) {
            this.rightArm.field_78796_g = -0.1f + this.head.field_78796_g;
            this.rightArm.field_78795_f = -1.5707964f + this.head.field_78795_f;
            this.leftArm.field_78795_f = -0.9424779f + this.head.field_78795_f;
            this.leftArm.field_78796_g = this.head.field_78796_g - 0.4f;
            this.leftArm.field_78808_h = 1.5707964f;
        } else if (GuardEntity$armpose == GuardEntity.ArmPose.CROSSBOW_HOLD) {
            this.rightArm.field_78796_g = -0.3f + this.head.field_78796_g;
            this.leftArm.field_78796_g = 0.6f + this.head.field_78796_g;
            this.rightArm.field_78795_f = -1.5707964f + this.head.field_78795_f + 0.1f;
            this.leftArm.field_78795_f = -1.5f + this.head.field_78795_f;
        } else if (GuardEntity$armpose == GuardEntity.ArmPose.CROSSBOW_CHARGE) {
            this.rightArm.field_78796_g = -0.8f;
            this.rightArm.field_78795_f = -0.97079635f;
            this.leftArm.field_78795_f = -0.97079635f;
            float f2 = MathHelper.func_76131_a((float)this.field_217145_m, (float)0.0f, (float)25.0f);
            this.leftArm.field_78796_g = MathHelper.func_219799_g((float)(f2 / 25.0f), (float)0.4f, (float)0.85f);
            this.leftArm.field_78795_f = MathHelper.func_219799_g((float)(f2 / 25.0f), (float)this.leftArm.field_78795_f, (float)-1.5707964f);
        } else if (GuardEntity$armpose == GuardEntity.ArmPose.CELEBRATING) {
            this.rightArm.field_78798_e = 0.0f;
            this.rightArm.field_78800_c = -5.0f;
            this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.rightArm.field_78808_h = 2.670354f;
            this.rightArm.field_78796_g = 0.0f;
            this.leftArm.field_78798_e = 0.0f;
            this.leftArm.field_78800_c = 5.0f;
            this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.leftArm.field_78808_h = -2.3561945f;
            this.leftArm.field_78796_g = 0.0f;
        }
        this.arms.field_78806_j = flag = GuardEntity$armpose == GuardEntity.ArmPose.CROSSED;
        this.leftArm.field_78806_j = !flag;
        this.rightArm.field_78806_j = !flag;
    }

    public void setLivingAnimations(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.field_217145_m = entityIn.func_184612_cw();
        super.func_212843_a_(entityIn, limbSwing, limbSwingAmount, partialTick);
    }

    private ModelRenderer getArm(HandSide p_191216_1_) {
        return p_191216_1_ == HandSide.LEFT ? this.leftArm : this.rightArm;
    }

    public ModelRenderer func_205062_a() {
        return this.hat;
    }

    public ModelRenderer func_205072_a() {
        return this.head;
    }

    public void func_225599_a_(HandSide sideIn, MatrixStack matrixStackIn) {
        this.getArm(sideIn).func_228307_a_(matrixStackIn);
    }
}

