/*
 * Decompiled with CFR 0.152.
 */
package net.mattbaker.guardscraft.network;

import java.util.function.Supplier;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketSpawn {
    private final ResourceLocation id;
    private final BlockPos pos;

    public PacketSpawn(PacketBuffer buf) {
        this.id = buf.func_192575_l();
        this.pos = buf.func_179259_c();
    }

    public PacketSpawn(ResourceLocation id, BlockPos pos) {
        this.id = id;
        this.pos = pos;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_192572_a(this.id);
        buf.func_179255_a(this.pos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerWorld spawnWorld = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_73046_m().func_71218_a(((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_234923_W_());
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(this.id);
            if (entityType == null) {
                throw new IllegalStateException("This cannot happen! Unknown id '" + this.id + "'!");
            }
            entityType.func_220331_a(spawnWorld, null, null, this.pos, SpawnReason.SPAWN_EGG, true, true);
        });
        ctx.get().setPacketHandled(true);
    }
}

