/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers;

import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.GuardEntity;
import tallestegg.guardvillagers.entities.goals.HealGolemGoal;
import tallestegg.guardvillagers.entities.goals.HealGuardAndPlayerGoal;

public class HandlerEvents {
    @SubscribeEvent
    public void onLivingSpawned(EntityJoinWorldEvent event) {
        AbstractVillagerEntity villager;
        if (GuardConfig.AttackAllMobs && event.getEntity() instanceof IMob) {
            MobEntity mob = (MobEntity)event.getEntity();
            mob.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal(mob, GuardEntity.class, false));
        }
        if (event.getEntity() instanceof AbstractIllagerEntity) {
            AbstractIllagerEntity illager = (AbstractIllagerEntity)event.getEntity();
            illager.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)illager, GuardEntity.class, false));
            if (GuardConfig.IllagersRunFromPolarBears) {
                illager.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)illager, PolarBearEntity.class, 6.0f, 1.0, 1.2));
            }
            if (GuardConfig.RaidAnimals && illager.func_213657_el()) {
                illager.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)illager, AnimalEntity.class, false));
            }
        }
        if (event.getEntity() instanceof GuardEntity) {
            GuardEntity guard = (GuardEntity)event.getEntity();
            guard.func_98053_h(true);
        }
        if (event.getEntity() instanceof AbstractVillagerEntity) {
            villager = (AbstractVillagerEntity)event.getEntity();
            if (GuardConfig.VillagersRunFromPolarBears) {
                villager.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)villager, PolarBearEntity.class, 6.0f, 1.0, 1.2));
            }
        }
        if (event.getEntity() instanceof VillagerEntity) {
            villager = (VillagerEntity)event.getEntity();
            villager.field_70714_bg.func_75776_a(1, (Goal)new HealGolemGoal((MobEntity)villager));
            villager.field_70714_bg.func_75776_a(1, (Goal)new HealGuardAndPlayerGoal((MobEntity)villager, 5.0, 60, 0, 10.0f));
        }
        if (event.getEntity() instanceof IronGolemEntity) {
            IronGolemEntity golem = (IronGolemEntity)event.getEntity();
            HurtByTargetGoal tolerateFriendlyFire = new HurtByTargetGoal((CreatureEntity)golem, new Class[]{GuardEntity.class}).func_220794_a(new Class[0]);
            golem.field_70715_bh.field_220892_d.stream().map(it -> it.field_220774_a).filter(it -> it instanceof HurtByTargetGoal).findFirst().ifPresent(angerGoal -> {
                golem.field_70715_bh.func_85156_a(angerGoal);
                golem.field_70715_bh.func_75776_a(2, (Goal)tolerateFriendlyFire);
            });
        }
        if (event.getEntity() instanceof ZombieEntity) {
            ZombieEntity zombie = (ZombieEntity)event.getEntity();
            zombie.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)zombie, GuardEntity.class, false));
        }
        if (event.getEntity() instanceof RavagerEntity) {
            RavagerEntity ravager = (RavagerEntity)event.getEntity();
            ravager.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)ravager, GuardEntity.class, false));
            if (GuardConfig.RaidAnimals && ravager.func_213657_el()) {
                ravager.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)ravager, AnimalEntity.class, false));
            }
        }
        if (event.getEntity() instanceof WitchEntity) {
            WitchEntity witch = (WitchEntity)event.getEntity();
            if (GuardConfig.WitchesVillager) {
                witch.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)witch, AbstractVillagerEntity.class, true));
                witch.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)witch, GuardEntity.class, false));
            }
            if (GuardConfig.IllagersRunFromPolarBears) {
                witch.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)witch, PolarBearEntity.class, 6.0f, 1.0, 1.2));
            }
            if (GuardConfig.RaidAnimals && witch.func_213657_el()) {
                witch.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)witch, AnimalEntity.class, false));
            }
        }
        if (event.getEntity() instanceof CatEntity) {
            CatEntity cat = (CatEntity)event.getEntity();
            cat.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)cat, AbstractIllagerEntity.class, 12.0f, 1.0, 1.2));
        }
        if (event.getEntity() instanceof IllusionerEntity) {
            IllusionerEntity illusioner = (IllusionerEntity)event.getEntity();
            illusioner.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)illusioner, GuardEntity.class, false));
            if (GuardConfig.RaidAnimals && illusioner.func_213657_el()) {
                illusioner.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)illusioner, AnimalEntity.class, false));
            }
        }
    }
}

