/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.configuration;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="guardvillagers", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GuardConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;
    public static boolean RaidAnimals;
    public static boolean WitchesVillager;
    public static boolean IllusionerRaids;
    public static boolean AttackAllMobs;
    public static boolean GuardSurrender;
    public static boolean VillagersRunFromPolarBears;
    public static boolean IllagersRunFromPolarBears;
    public static boolean GuardsRunFromPolarBears;
    public static boolean IllagersOpenDoors;
    public static boolean GuardsOpenDoors;
    public static boolean GuardAlwaysShield;
    public static boolean GuardFormation;
    public static boolean FriendlyFire;

    public static void bakeConfig() {
        RaidAnimals = (Boolean)GuardConfig.COMMON.RaidAnimals.get();
        WitchesVillager = (Boolean)GuardConfig.COMMON.WitchesVillager.get();
        IllusionerRaids = (Boolean)GuardConfig.COMMON.IllusionerRaids.get();
        AttackAllMobs = (Boolean)GuardConfig.COMMON.AttackAllMobs.get();
        GuardSurrender = (Boolean)GuardConfig.COMMON.GuardSurrender.get();
        VillagersRunFromPolarBears = (Boolean)GuardConfig.COMMON.VillagersRunFromPolarBears.get();
        IllagersRunFromPolarBears = (Boolean)GuardConfig.COMMON.IllagersRunFromPolarBears.get();
        GuardsOpenDoors = (Boolean)GuardConfig.COMMON.GuardsOpenDoors.get();
        GuardAlwaysShield = (Boolean)GuardConfig.COMMON.GuardRaiseShield.get();
        GuardFormation = (Boolean)GuardConfig.COMMON.GuardFormation.get();
        FriendlyFire = (Boolean)GuardConfig.COMMON.FriendlyFire.get();
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            GuardConfig.bakeConfig();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.BooleanValue RaidAnimals;
        public final ForgeConfigSpec.BooleanValue WitchesVillager;
        public final ForgeConfigSpec.BooleanValue IllusionerRaids;
        public final ForgeConfigSpec.BooleanValue AttackAllMobs;
        public final ForgeConfigSpec.BooleanValue GuardSurrender;
        public final ForgeConfigSpec.BooleanValue VillagersRunFromPolarBears;
        public final ForgeConfigSpec.BooleanValue IllagersRunFromPolarBears;
        public final ForgeConfigSpec.BooleanValue GuardsRunFromPolarBears;
        public final ForgeConfigSpec.BooleanValue GuardsOpenDoors;
        public final ForgeConfigSpec.BooleanValue GuardRaiseShield;
        public final ForgeConfigSpec.BooleanValue GuardFormation;
        public final ForgeConfigSpec.BooleanValue FriendlyFire;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            this.RaidAnimals = builder.comment("Illagers In Raids Attack Animals?").translation("guardvillagers.config.RaidAnimals").define("Illagers In Raids Attack Animals?", false);
            this.WitchesVillager = builder.comment("Witches Attack Villagers?").translation("guardvillagers.config.WitchesVillager").define("Witches Attack Villagers?", true);
            this.IllusionerRaids = builder.comment("This will make Illusioners get involved in raids").translation("guardvillagers.config.IllusionerRaids").define("Have Illusioners in Raids?", false);
            this.AttackAllMobs = builder.comment("Guards will attack all hostiles with this option").translation("guardvillagers.config.AttackAllMobs").define("Guards Attack All Mobs?", false);
            this.GuardSurrender = builder.comment("This option makes guards run from ravagers when low on health").translation("guardvillagers.config.GuardSurrender").define("Have Guards be run from ravagers when on low health?", true);
            this.VillagersRunFromPolarBears = builder.comment("This makes villagers run from polar bears, as anyone with common sense would.").translation("guardvillagers.config.VillagersRunFromPolarBears").define("Have Villagers have some common sense?", true);
            this.IllagersRunFromPolarBears = builder.comment("This makes Illagers run from polar bears, as anyone with common sense would.").translation("guardvillagers.config.IllagersRunFromPolarBears").define("Have Illagers have some common sense?", true);
            this.GuardsRunFromPolarBears = builder.comment("This makes Guards run from polar bears, as anyone with common sense would.").translation("guardvillagers.config.IllagersRunFromPolarBears").define("Have Guards have some common sense?", false);
            this.GuardsOpenDoors = builder.comment("This lets Guards open doors.").translation("guardvillagers.config.GuardsOpenDoors").define("Have Guards open doors?", true);
            this.GuardRaiseShield = builder.comment("This will make guards raise their shields all the time, on default they will only raise their shields under certain conditions").translation("guardvillagers.config.GuardRaiseShield").define("Have Guards raise their shield all the time?", false);
            this.GuardFormation = builder.comment("This makes guards form a phalanx").translation("guardvillagers.config.GuardFormation").define("Have guards form a phalanx?", true);
            this.FriendlyFire = builder.comment("This will make guards attempt to avoid friendly fire.").translation("guardvillagers.config.FriendlyFire").define("Have guards avoid friendly fire?", false);
        }
    }
}

