/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities;

import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.PatrolVillageGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.ReturnToVillageGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import tallestegg.guardvillagers.GuardItems;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.goals.FollowShieldGuards;
import tallestegg.guardvillagers.entities.goals.HelpVillagerGoal;
import tallestegg.guardvillagers.entities.goals.HeroHurtByTargetGoal;
import tallestegg.guardvillagers.entities.goals.HeroHurtTargetGoal;
import tallestegg.guardvillagers.entities.goals.RangedCrossbowAttackPassiveGoal;
import tallestegg.guardvillagers.entities.goals.WalkRunWhileReloading;

public class GuardEntity
extends CreatureEntity
implements ICrossbowUser,
IRangedAttackMob,
IAngerable {
    private static final DataParameter<Integer> GUARD_VARIANT = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DATA_CHARGING_STATE = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> KICKING = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int kickTicks;
    public int arrowsFired;
    public boolean following;
    public int coolDown;
    public PlayerEntity hero;
    private int field_234197_bv_;
    private static final RangedInteger field_234196_bu_ = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private UUID field_234198_bw_;
    private final RangedCrossbowAttackPassiveGoal<GuardEntity> aiCrossBowAttack = new RangedCrossbowAttackPassiveGoal<GuardEntity>(this, 1.0, 8.0f);
    private final MeleeAttackGoal aiAttackOnCollide = new MeleeAttackGoal(this, 0.9, true){

        public void func_75251_c() {
            super.func_75251_c();
            GuardEntity.this.func_213395_q(false);
            GuardEntity.this.coolDown = 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            GuardEntity.this.func_213395_q(true);
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return super.func_179512_a(attackTarget) * 3.55;
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.field_234037_i_ <= 0) {
                this.field_234037_i_ = 20;
                this.field_75441_b.func_184609_a(Hand.MAIN_HAND);
                this.field_75441_b.func_70652_k((Entity)enemy);
                GuardEntity.this.func_184602_cy();
                GuardEntity.this.coolDown = 8;
            }
        }
    };

    public GuardEntity(EntityType<? extends GuardEntity> type, World world) {
        super(type, world);
        this.func_110163_bv();
        this.func_98053_h(true);
        if (GuardConfig.GuardsOpenDoors) {
            ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        }
        this.setCombatTask();
        this.arrowsFired = 0;
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_110163_bv();
        int type = GuardEntity.getRandomTypeForBiome((IWorld)this.field_70170_p, this.func_233580_cy_());
        if (spawnDataIn instanceof GuardData) {
            type = ((GuardData)spawnDataIn).variantData;
            spawnDataIn = new GuardData(type);
        }
        this.setCombatTask();
        this.func_98053_h(true);
        if (this.field_70170_p.field_73012_v.nextFloat() < 0.5f) {
            this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)Items.field_185159_cQ));
        }
        this.setGuardVariant(type);
        this.func_180481_a(difficultyIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void setCombatTask() {
        this.field_70715_bh.func_85156_a((Goal)this.aiAttackOnCollide);
        this.field_70715_bh.func_85156_a(this.aiCrossBowAttack);
        ItemStack itemstack = this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_222114_py));
        if (itemstack.func_77973_b() instanceof CrossbowItem) {
            this.field_70715_bh.func_75776_a(3, this.aiCrossBowAttack);
        } else {
            this.field_70715_bh.func_75776_a(3, (Goal)this.aiAttackOnCollide);
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (this.func_184592_cb().func_77975_n() == UseAction.BLOCK && this.func_213398_dR() && this.func_184600_cs() == Hand.OFF_HAND) {
            return SoundEvents.field_187767_eL;
        }
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setGuardVariant(compound.func_74762_e("Type"));
        this.kickTicks = compound.func_74762_e("KickTicks");
        this.following = compound.func_74767_n("Following");
        this.coolDown = compound.func_74762_e("Cooldown");
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
        this.setCombatTask();
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76346_g() instanceof ZombieEntity && (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL || this.field_70170_p.func_175659_aa() == Difficulty.HARD)) {
            if (this.field_70170_p.func_175659_aa() != Difficulty.HARD && this.field_70146_Z.nextBoolean()) {
                return;
            }
            ZombieEntity zombie = (ZombieEntity)cause.func_76346_g();
            ZombieVillagerEntity zillager = (ZombieVillagerEntity)EntityType.field_200727_aF.func_200721_a(this.field_70170_p);
            zillager.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.CONVERSION, (ILivingEntityData)null, (CompoundNBT)null);
            zillager.func_82149_j((Entity)this);
            if (this.func_145818_k_()) {
                zillager.func_200203_b(zillager.func_200201_e());
                zillager.func_174805_g(this.func_174833_aM());
            }
            if (this.func_104002_bU()) {
                zillager.func_110163_bv();
            }
            zillager.func_184201_a(EquipmentSlotType.MAINHAND, this.func_184614_ca().func_77946_l());
            zillager.func_184201_a(EquipmentSlotType.OFFHAND, this.func_184592_cb().func_77946_l());
            zillager.func_184201_a(EquipmentSlotType.HEAD, this.func_184582_a(EquipmentSlotType.HEAD).func_77946_l());
            zillager.func_184201_a(EquipmentSlotType.CHEST, this.func_184582_a(EquipmentSlotType.CHEST).func_77946_l());
            zillager.func_184201_a(EquipmentSlotType.LEGS, this.func_184582_a(EquipmentSlotType.LEGS).func_77946_l());
            zillager.func_184201_a(EquipmentSlotType.FEET, this.func_184582_a(EquipmentSlotType.FEET).func_77946_l());
            zillager.func_82227_f(false);
            zillager.func_94061_f(this.func_175446_cd());
            zillager.func_184224_h(this.func_190530_aW());
            zombie.field_70170_p.func_217376_c((Entity)zillager);
            this.func_70106_y();
            zombie.field_70170_p.func_217378_a((PlayerEntity)null, 1026, zombie.func_233580_cy_(), 0);
        }
    }

    public void func_70636_d() {
        if (this.kickTicks > 0) {
            ++this.kickTicks;
            LivingEntity attacker = this.func_70638_az();
            if (this.kickTicks == 10 && attacker != null) {
                this.func_184602_cy();
                this.coolDown = 15;
                this.func_70652_k((Entity)attacker);
                this.func_70625_a((Entity)attacker, 30.0f, 30.0f);
                attacker.func_233627_a_(1.0f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            }
        }
        if (this.coolDown > 0) {
            --this.coolDown;
        }
        this.func_82168_bl();
        this.raiseShield();
        super.func_70636_d();
    }

    protected void func_190629_c(LivingEntity entityIn) {
        super.func_190629_c(entityIn);
        if (entityIn.func_184614_ca().canDisableShield(this.field_184627_bm, (LivingEntity)this, entityIn)) {
            this.disableShield(true);
        }
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        EquipmentSlotType equipmentslottype = GuardEntity.func_184640_d((ItemStack)itemstack);
        ItemStack itemstack1 = this.func_184582_a(equipmentslottype);
        if (this.func_175448_a(itemstack) && itemEntity.func_92059_d().func_77973_b() instanceof ArmorItem && this.coolDown == 0) {
            if (!itemstack1.func_190926_b()) {
                this.func_199701_a_(itemstack1);
            }
            this.coolDown = 200;
            this.func_184201_a(equipmentslottype, itemstack);
            switch (equipmentslottype.func_188453_a()) {
                case HAND: {
                    this.field_82174_bp[equipmentslottype.func_188454_b()] = 2.0f;
                    break;
                }
                case ARMOR: {
                    this.field_184655_bs[equipmentslottype.func_188454_b()] = 2.0f;
                }
            }
            this.func_110163_bv();
            this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
            itemEntity.func_70106_y();
        }
    }

    public void disableShield(boolean p_190777_1_) {
        float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
        if (p_190777_1_) {
            f += 0.75f;
        }
        if (this.field_70146_Z.nextFloat() < f) {
            this.coolDown = 100;
            this.func_184602_cy();
            this.field_70170_p.func_72960_a((Entity)this, (byte)30);
        }
    }

    public void raiseShield() {
        if (this.func_184592_cb().func_77973_b() instanceof ShieldItem && this.func_70638_az() != null && (double)this.func_70638_az().func_70032_d((Entity)this) <= 4.0 && this.coolDown == 0 || this.func_184592_cb().func_77973_b() instanceof ShieldItem && GuardConfig.GuardAlwaysShield || this.func_184592_cb().func_77973_b() instanceof ShieldItem && this.func_70638_az() != null && this.func_70638_az() instanceof CreeperEntity || this.func_184592_cb().func_77973_b() instanceof ShieldItem && this.func_70638_az() != null && this.func_70638_az() instanceof IRangedAttackMob && (double)this.func_70638_az().func_70032_d((Entity)this) >= 5.0 && !(this.func_184614_ca().func_77973_b() instanceof CrossbowItem)) {
            this.func_184598_c(Hand.OFF_HAND);
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.3f);
        }
        if (this.func_184592_cb().func_77973_b() instanceof ShieldItem && !this.func_213398_dR() && !GuardConfig.GuardAlwaysShield) {
            this.func_184602_cy();
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.5);
        }
    }

    public void kick(float f1) {
        this.setKicking(true);
        this.kickTicks = 9;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GUARD_VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(DATA_CHARGING_STATE, (Object)false);
        this.field_70180_af.func_187214_a(KICKING, (Object)false);
    }

    public boolean isCharging() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_CHARGING_STATE);
    }

    public void func_213671_a(boolean p_213671_1_) {
        this.field_70180_af.func_187227_b(DATA_CHARGING_STATE, (Object)p_213671_1_);
    }

    public boolean isKicking() {
        return (Boolean)this.field_70180_af.func_187225_a(KICKING);
    }

    public void setKicking(boolean p_213671_1_) {
        this.field_70180_af.func_187227_b(KICKING, (Object)p_213671_1_);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        int i = this.field_70146_Z.nextInt(2);
        switch (i) {
            case 0: {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151040_l));
                break;
            }
            case 1: {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_222114_py));
            }
        }
        this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 100.0f;
        this.field_82174_bp[EquipmentSlotType.OFFHAND.func_188454_b()] = 100.0f;
        super.func_180481_a(difficulty);
    }

    public int getGuardVariant() {
        return (Integer)this.field_70180_af.func_187225_a(GUARD_VARIANT);
    }

    public void setGuardVariant(int typeId) {
        this.field_70180_af.func_187227_b(GUARD_VARIANT, (Object)typeId);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)GuardItems.GUARD_SPAWN_EGG.get());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new ReturnToVillageGoal((CreatureEntity)this, 0.6, false));
        this.field_70714_bg.func_75776_a(1, (Goal)new PatrolVillageGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(1, (Goal)new HeroHurtTargetGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveThroughVillageGoal((CreatureEntity)this, 0.6, false, 4, () -> false));
        this.field_70714_bg.func_75776_a(2, (Goal)new WalkRunWhileReloading(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowHeroGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new HeroHurtByTargetGoal(this));
        if (GuardConfig.GuardSurrender) {
            this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal<RavagerEntity>((CreatureEntity)this, RavagerEntity.class, 12.0f, 1.0, 1.2){

                public boolean func_75250_a() {
                    return ((GuardEntity)this.field_75380_a).func_110143_aJ() < 13.0f && !(this.field_75380_a.func_184592_cb().func_77973_b() instanceof ShieldItem) && super.func_75250_a();
                }

                public void func_75249_e() {
                    if (((GuardEntity)this.field_75380_a).func_70638_az() == this.field_75376_d) {
                        ((GuardEntity)this.field_75380_a).func_70624_b(null);
                    }
                }
            });
        }
        if (GuardConfig.GuardSurrender) {
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal<RavagerEntity>((MobEntity)this, RavagerEntity.class, true){

                public boolean func_75250_a() {
                    return ((GuardEntity)this.field_75299_d).func_110143_aJ() > 13.0f && super.func_75250_a();
                }
            });
        }
        if (GuardConfig.GuardFormation) {
            this.field_70714_bg.func_75776_a(2, (Goal)new FollowShieldGuards(this));
        }
        this.field_70714_bg.func_75776_a(2, (Goal)new DefendVillageGuardGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new HelpVillagerGoal((MobEntity)this));
        if (GuardConfig.GuardsOpenDoors) {
            this.field_70714_bg.func_75776_a(3, (Goal)new OpenDoorGoal((MobEntity)this, true));
        }
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveToArmorPieceGoal(this));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, AbstractVillagerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(15, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombieEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractIllagerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, WitchEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IllusionerEntity.class, true));
        if (!GuardConfig.GuardSurrender) {
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, RavagerEntity.class, true));
        }
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{GuardEntity.class, IronGolemEntity.class}).func_220794_a(new Class[0]));
        if (GuardConfig.GuardsRunFromPolarBears) {
            this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, PolarBearEntity.class, 12.0f, 1.0, 1.2));
        }
        if (GuardConfig.AttackAllMobs) {
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, true, true, mob -> mob instanceof IMob));
        }
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((GuardEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetAngerGoal((MobEntity)this, false));
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        this.func_234281_b_((LivingEntity)this, 6.0f);
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K) {
            this.setCombatTask();
        }
    }

    public ItemStack func_213356_f(ItemStack shootable) {
        if (shootable.func_77973_b() instanceof ShootableItem) {
            Predicate predicate = ((ShootableItem)shootable.func_77973_b()).func_220006_d();
            ItemStack itemstack = ShootableItem.func_220005_a((LivingEntity)this, (Predicate)predicate);
            return itemstack.func_190926_b() ? new ItemStack((IItemProvider)Items.field_151032_g) : itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Type", this.getGuardVariant());
        compound.func_74768_a("KickTicks", this.kickTicks);
        compound.func_74768_a("Cooldown", this.coolDown);
        compound.func_74757_a("Following", this.following);
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
    }

    public int getKickTicks() {
        return this.kickTicks;
    }

    public boolean func_213358_a(EntityType<?> typeIn) {
        if (this.following && typeIn == EntityType.field_200729_aH || this.hero != null && typeIn == EntityType.field_200729_aH) {
            return false;
        }
        return super.func_213358_a(typeIn);
    }

    public static int getRandomTypeForBiome(IWorld world, BlockPos pos) {
        Biome biome = world.func_226691_t_(pos);
        if (biome.func_201856_r() == Biome.Category.PLAINS) {
            return 0;
        }
        if (biome.func_201856_r() == Biome.Category.DESERT) {
            return 1;
        }
        if (biome.func_201856_r() == Biome.Category.SAVANNA) {
            return 2;
        }
        if (biome.func_201856_r() == Biome.Category.SWAMP) {
            return 3;
        }
        if (biome.func_201856_r() == Biome.Category.JUNGLE) {
            return 4;
        }
        if (biome.func_201856_r() == Biome.Category.TAIGA) {
            return 5;
        }
        if (biome.func_201856_r() == Biome.Category.ICY) {
            return 6;
        }
        return 0;
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() instanceof CreatureEntity) {
            CreatureEntity creatureentity = (CreatureEntity)this.func_184187_bx();
            this.field_70761_aq = creatureentity.field_70761_aq;
        }
    }

    public void func_230283_U__() {
    }

    public void func_230284_a_(LivingEntity arg0, ItemStack arg1, ProjectileEntity arg2, float arg3) {
        this.func_234279_a_((LivingEntity)this, arg0, arg2, arg3, 1.6f);
    }

    protected void func_213371_e(LivingEntity entityIn) {
        if (this.isKicking()) {
            this.setKicking(false);
        }
        super.func_213371_e((LivingEntity)this);
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (!(heldStack.func_77973_b() instanceof ShieldItem || heldStack.func_77973_b() instanceof ArrowItem || heldStack.func_77973_b() instanceof FireworkRocketItem || heldStack.func_77973_b().func_219971_r() || !player.func_213453_ef() || this.func_70638_az() == player || this.field_70170_p.field_72995_K)) {
            this.func_199701_a_(this.func_184614_ca());
            this.func_184201_a(EquipmentSlotType.MAINHAND, heldStack.func_77946_l());
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        if ((heldStack.func_77973_b() instanceof ShieldItem && player.func_213453_ef() || heldStack.func_77973_b() instanceof ArrowItem && player.func_213453_ef() || heldStack.func_77973_b() instanceof FireworkRocketItem && player.func_213453_ef()) && this.func_70638_az() != player && !this.field_70170_p.field_72995_K) {
            this.func_199701_a_(this.func_184592_cb());
            this.func_184201_a(EquipmentSlotType.OFFHAND, heldStack.func_77946_l());
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        if (heldStack.func_77973_b().func_219971_r() && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(heldStack.func_77973_b().func_219967_s().func_221466_a());
            this.playHealEffect(true);
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        if (player.func_70644_a(Effects.field_220310_F)) {
            this.func_184185_a(SoundEvents.field_219721_mv, 1.0f, 1.0f);
            this.following = !this.following;
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    protected void playHealEffect(boolean play) {
        BasicParticleType iparticledata = ParticleTypes.field_197632_y;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)iparticledata, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
        }
    }

    public static String getNameByType(int id) {
        switch (id) {
            case 0: {
                return "plains";
            }
            case 1: {
                return "desert";
            }
            case 2: {
                return "savanna";
            }
            case 3: {
                return "swamp";
            }
            case 4: {
                return "jungle";
            }
            case 5: {
                return "taiga";
            }
            case 6: {
                return "snow";
            }
        }
        return "";
    }

    public int func_230256_F__() {
        return this.field_234197_bv_;
    }

    public UUID func_230257_G__() {
        return this.field_234198_bw_;
    }

    public void func_230258_H__() {
        this.func_230260_a__(field_234196_bu_.func_233018_a_(this.field_70146_Z));
    }

    public void func_230259_a_(@Nullable UUID arg0) {
        this.field_234198_bw_ = arg0;
    }

    public void func_230260_a__(int arg0) {
        this.field_234197_bv_ = arg0;
    }

    public static AttributeModifierMap.MutableAttribute func_234200_m_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233819_b_, 25.0);
    }

    public static class FollowHeroGoal
    extends Goal {
        public final GuardEntity guard;
        protected final EntityPredicate whateverthisis = new EntityPredicate().func_221013_a(64.0);

        public FollowHeroGoal(GuardEntity mob) {
            this.guard = mob;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.guard.following = true;
        }

        public boolean func_75253_b() {
            super.func_75253_b();
            return this.guard.following;
        }

        public boolean func_75250_a() {
            List list = this.guard.field_70170_p.func_217357_a(PlayerEntity.class, this.guard.func_174813_aQ().func_186662_g(10.0));
            if (!list.isEmpty()) {
                for (LivingEntity mob : list) {
                    PlayerEntity player = (PlayerEntity)mob;
                    if (player.func_82150_aj() || !player.func_70644_a(Effects.field_220310_F)) continue;
                    this.guard.hero = player;
                    if (this.guard.following) {
                        this.guard.func_70661_as().func_75497_a((Entity)this.guard.hero, 0.9);
                    }
                    return this.guard.following;
                }
            }
            return false;
        }

        public void func_75251_c() {
            this.guard.func_70661_as().func_75499_g();
            this.guard.following = false;
            this.guard.hero = null;
        }
    }

    public static class DefendVillageGuardGoal
    extends TargetGoal {
        protected final GuardEntity guard;
        protected LivingEntity villageAggressorTarget;
        protected final EntityPredicate field_223190_c = new EntityPredicate().func_221013_a(64.0);

        public DefendVillageGuardGoal(GuardEntity guardIn) {
            super((MobEntity)guardIn, false, true);
            this.guard = guardIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean func_75250_a() {
            AxisAlignedBB axisalignedbb = this.guard.func_174813_aQ().func_72314_b(10.0, 8.0, 10.0);
            List list = this.guard.field_70170_p.func_217374_a(VillagerEntity.class, this.field_223190_c, (LivingEntity)this.guard, axisalignedbb);
            List list1 = this.guard.field_70170_p.func_217373_a(this.field_223190_c, (LivingEntity)this.guard, axisalignedbb);
            for (LivingEntity livingentity : list) {
                VillagerEntity villagerentity = (VillagerEntity)livingentity;
                for (PlayerEntity playerentity : list1) {
                    int i = villagerentity.func_223107_f(playerentity);
                    if (i > -100) continue;
                    this.villageAggressorTarget = playerentity;
                }
            }
            if (this.villageAggressorTarget == null) {
                return false;
            }
            return !(this.villageAggressorTarget instanceof PlayerEntity) || !this.villageAggressorTarget.func_175149_v() && !((PlayerEntity)this.villageAggressorTarget).func_184812_l_();
        }

        public void func_75249_e() {
            this.guard.func_70624_b(this.villageAggressorTarget);
            super.func_75249_e();
        }
    }

    public static class MoveToArmorPieceGoal
    extends Goal {
        private final GuardEntity guard;

        public MoveToArmorPieceGoal(GuardEntity guard) {
            this.guard = guard;
        }

        public boolean func_75250_a() {
            List list = this.guard.field_70170_p.func_217357_a(ItemEntity.class, this.guard.func_174813_aQ().func_72314_b(3.0, 3.0, 3.0));
            if (!list.isEmpty() && ((ItemEntity)list.get(0)).func_92059_d().func_77973_b() instanceof ArmorItem) {
                return this.guard.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.15f);
            }
            return false;
        }
    }

    public static class GuardData
    implements ILivingEntityData {
        public final int variantData;

        public GuardData(int type) {
            this.variantData = type;
        }
    }
}

