/*
 * Decompiled with CFR 0.152.
 */
package io.github.a5b84.helditeminfo;

import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1745;
import net.minecraft.class_1772;
import net.minecraft.class_1781;
import net.minecraft.class_1785;
import net.minecraft.class_1788;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1803;
import net.minecraft.class_1812;
import net.minecraft.class_1813;
import net.minecraft.class_1822;
import net.minecraft.class_1833;
import net.minecraft.class_1836;
import net.minecraft.class_1843;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_341;

public final class ItemInfo {
    public static final int MAX_LINES = 6;
    public static final int MAX_COMMAND_LINES = 2;
    public static final int MAX_COMMAND_LINE_LENGTH = 32;
    protected static final class_327 textRenderer = class_310.method_1551().field_1772;

    private ItemInfo() {
    }

    public static List<InfoLine> buildInfo(class_1799 stack) {
        class_2561 stackName = new class_2585("").method_10852(stack.method_7964()).method_10854(stack.method_7932().field_8908);
        if (stack.method_7938()) {
            stackName.method_10854(class_124.field_1056);
        }
        ArrayList<class_2561> texts = new ArrayList<class_2561>(6);
        texts.add(stackName);
        if (ItemInfo.appendBeehiveContent(texts, stack) || ItemInfo.appendCommandBlockInfo(texts, stack) || ItemInfo.appendPotionEffects(texts, stack) || ItemInfo.appendSignText(texts, stack) || ItemInfo.appendUsualTooltip(texts, stack, class_1745.class) || ItemInfo.appendUsualTooltip(texts, stack, class_1781.class) || ItemInfo.appendUsualTooltip(texts, stack, class_1785.class) || ItemInfo.appendUsualTooltip(texts, stack, class_1813.class) || ItemInfo.appendUsualTooltip(texts, stack, class_1843.class)) {
            // empty if block
        }
        if (stack.method_7985()) {
            ItemInfo.appendContainerContent(texts, stack);
            ItemInfo.appendEnchantments(texts, stack);
            ItemInfo.appendUnbreakable(texts, stack);
        }
        ArrayList<InfoLine> info = new ArrayList<InfoLine>(texts.size());
        for (class_2561 text : texts) {
            info.add(new InfoLine(text));
        }
        return info;
    }

    protected static boolean appendToInfo(List<class_2561> info, List<class_2561> list) {
        if (info.size() >= 6) {
            return false;
        }
        if (6 - info.size() < list.size()) {
            int addedLength = 6 - info.size() - 1;
            info.addAll(list.subList(0, addedLength));
            info.add(new class_2588("container.shulkerBox.more", new Object[]{list.size() - addedLength}).method_10856(new class_124[]{class_124.field_1080, class_124.field_1056}));
            return true;
        }
        info.addAll(list);
        return !info.isEmpty();
    }

    protected static boolean appendUsualTooltip(List<class_2561> info, class_1799 stack, Class<? extends class_1792> clazz) {
        if (info.size() >= 6 || !clazz.isInstance(stack.method_7909())) {
            return false;
        }
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        stack.method_7909().method_7851(stack, null, tooltip, (class_1836)class_1836.class_1837.field_8934);
        return ItemInfo.appendToInfo(info, tooltip);
    }

    protected static boolean appendBeehiveContent(List<class_2561> info, class_1799 stack) {
        if (info.size() >= 6 || stack.method_7909() != class_1802.field_20415 && stack.method_7909() != class_1802.field_20416) {
            return false;
        }
        class_2487 blockEntityTag = stack.method_7941("BlockEntityTag");
        if (blockEntityTag == null) {
            return false;
        }
        int beeCount = blockEntityTag.method_10554("Bees", 10).size();
        if (beeCount == 0) {
            return false;
        }
        info.add(new class_2588("entity.minecraft.bee", new Object[0]).method_10864(" x" + beeCount).method_10854(class_124.field_1080));
        return true;
    }

    protected static boolean appendCommandBlockInfo(List<class_2561> info, class_1799 stack) {
        boolean shouldCut;
        if (info.size() >= 6 || !(stack.method_7909() instanceof class_1788)) {
            return false;
        }
        class_2487 blockEntityTag = stack.method_7941("BlockEntityTag");
        if (blockEntityTag == null) {
            return false;
        }
        String command = blockEntityTag.method_10558("Command").trim();
        if (command.isEmpty()) {
            return false;
        }
        int maxLines = Math.min(6 - info.size(), 2);
        int maxLength = (int)((double)(maxLines * 32) * 1.125);
        boolean bl = shouldCut = command.length() > maxLength;
        if (shouldCut) {
            command = command.substring(0, maxLength);
        }
        List<class_2561> lines = class_341.method_1850((class_2561)new class_2585(command), (int)192, (class_327)textRenderer, (boolean)false, (boolean)false);
        if (shouldCut || lines.size() > maxLines) {
            if (lines.size() > maxLines) {
                lines = lines.subList(0, maxLines);
            }
            ((class_2561)lines.get(maxLines - 1)).method_10864("...");
        }
        for (class_2561 text : lines) {
            text.method_10854(class_124.field_1080);
        }
        return ItemInfo.appendToInfo(info, lines);
    }

    protected static boolean appendContainerContent(List<class_2561> info, class_1799 stack) {
        if (info.size() >= 6) {
            return false;
        }
        class_2487 tag = stack.method_7941("BlockEntityTag");
        if (tag == null) {
            return false;
        }
        class_2499 items = tag.method_10554("Items", 10);
        ArrayList<class_2561> newInfo = new ArrayList<class_2561>(6 - info.size());
        if (tag.method_10573("LootTable", 8)) {
            newInfo.add((class_2561)new class_2585("???????"));
        }
        if (!items.isEmpty()) {
            for (int i = 0; i < items.size(); ++i) {
                class_1799 iStack;
                class_2487 itemTag = items.method_10602(i);
                if (itemTag.isEmpty() || (iStack = class_1799.method_7915((class_2487)itemTag)).method_7960()) continue;
                if (info.size() + newInfo.size() < 6) {
                    newInfo.add(iStack.method_7964().method_10864(" x" + iStack.method_7947()).method_10854(class_124.field_1080));
                    continue;
                }
                newInfo.add(null);
            }
        }
        return ItemInfo.appendToInfo(info, newInfo);
    }

    protected static boolean appendEnchantments(List<class_2561> info, class_1799 stack) {
        if (info.size() >= 6 || !stack.method_7909().method_7870(stack) && !(stack.method_7909() instanceof class_1772) || (stack.method_7969().method_10550("HideFlags") & 1) != 0) {
            return false;
        }
        class_2499 enchantments = stack.method_7909() == class_1802.field_8598 ? class_1772.method_7806((class_1799)stack) : stack.method_7921();
        ArrayList<class_2561> enchantmentTexts = new ArrayList<class_2561>(enchantments.size());
        class_1799.method_17870(enchantmentTexts, (class_2499)enchantments);
        return ItemInfo.appendToInfo(info, enchantmentTexts);
    }

    protected static boolean appendPotionEffects(List<class_2561> info, class_1799 stack) {
        List<Object> potionInfo = new ArrayList<class_2561>(6);
        if (!(ItemInfo.appendUsualTooltip(potionInfo, stack, class_1812.class) || ItemInfo.appendUsualTooltip(potionInfo, stack, class_1803.class) || ItemInfo.appendUsualTooltip(potionInfo, stack, class_1833.class))) {
            return false;
        }
        for (int i = potionInfo.size() - 1; i >= 0; --i) {
            class_2561 line = (class_2561)potionInfo.get(i);
            if (!(line instanceof class_2585) || !line.method_10851().equals("")) continue;
            potionInfo = potionInfo.subList(0, i);
            break;
        }
        return ItemInfo.appendToInfo(info, potionInfo);
    }

    protected static boolean appendSignText(List<class_2561> info, class_1799 stack) {
        if (info.size() >= 6 || !(stack.method_7909() instanceof class_1822)) {
            return false;
        }
        class_2487 blockEntityTag = stack.method_7941("BlockEntityTag");
        if (blockEntityTag == null) {
            return false;
        }
        ArrayList<class_2561> lines = new ArrayList<class_2561>(4);
        for (int i = 0; i < 4; ++i) {
            class_2561 text;
            try {
                text = class_2561.class_2562.method_10877((String)blockEntityTag.method_10558("Text" + (i + 1)));
            }
            catch (JsonParseException e) {
                continue;
            }
            System.out.println("yyyy" + text);
            if (text == null) continue;
            String str = text.method_10851();
            System.out.println("yyyy" + str);
            if (str.trim().isEmpty()) continue;
            while (lines.size() < i) {
                lines.add((class_2561)new class_2585(""));
            }
            lines.add((class_2561)new class_2585(str));
        }
        for (class_2561 text : lines) {
            text.method_10854(class_124.field_1080);
        }
        return ItemInfo.appendToInfo(info, lines);
    }

    protected static boolean appendUnbreakable(List<class_2561> info, class_1799 stack) {
        if (info.size() >= 6 || !stack.method_7909().method_7846()) {
            return false;
        }
        class_2487 tag = stack.method_7969();
        if (!tag.method_10577("Unbreakable") || (tag.method_10550("HideFlags") & 4) != 0) {
            return false;
        }
        info.add(new class_2588("item.unbreakable", new Object[0]).method_10854(class_124.field_1078));
        return true;
    }

    public static class InfoLine {
        public final String formatted;
        public final int width;

        InfoLine(class_2561 text) {
            this.formatted = text.method_10863();
            this.width = textRenderer.method_1727(this.formatted);
        }
    }
}

