/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager.entity;

import baguchan.hunterillager.HunterSounds;
import baguchan.hunterillager.entity.ai.EatOffhandFoodGoal;
import baguchan.hunterillager.entity.ai.GotoBedGoal;
import baguchan.hunterillager.entity.ai.RangedAggroedAttackGoal;
import baguchan.hunterillager.entity.ai.WakeUpGoal;
import baguchan.hunterillager.entity.projectile.BoomerangEntity;
import baguchan.hunterillager.init.HunterItems;
import baguchan.hunterillager.item.BoomerangItem;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HunterIllagerEntity
extends AbstractIllagerEntity
implements IRangedAttackMob {
    private static final Predicate<ItemEntity> food = p_213647_0_ -> !p_213647_0_.func_174874_s() && p_213647_0_.func_70089_S() && HunterIllagerEntity.isFoods(p_213647_0_.func_92059_d().func_77973_b());
    private static final UUID MODIFIER_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final DataParameter<Boolean> IS_EATING = EntityDataManager.func_187226_a(HunterIllagerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> TYPE = EntityDataManager.func_187226_a(HunterIllagerEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private int foodUseTimer;
    @Nullable
    private BlockPos homePosition;
    private final Inventory inventory = new Inventory(5);
    public static final Predicate<LivingEntity> animalTarget = p_213440_0_ -> {
        EntityType entitytype = p_213440_0_.func_200600_R();
        return entitytype != EntityType.field_220360_g && entitytype != EntityType.field_220356_B && entitytype != EntityType.field_226289_e_ && entitytype != EntityType.field_220353_aa && !(p_213440_0_ instanceof TameableEntity) && !(p_213440_0_ instanceof AbstractHorseEntity) || entitytype == EntityType.field_200745_ak;
    };
    protected int eattick = 0;
    private int cooldownTicks;

    public HunterIllagerEntity(EntityType<HunterIllagerEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 6;
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_184642_a(EquipmentSlotType.OFFHAND, 0.4f);
        this.func_98053_h(true);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(2, new EatOffhandFoodGoal<HunterIllagerEntity>(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.85f, false){

            public boolean func_75250_a() {
                return !HunterIllagerEntity.this.isHolding(Items.field_151031_f) && !HunterIllagerEntity.this.isHolding(HunterItems.BOOMERANG) && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(3, (Goal)new RangedAggroedAttackGoal(this, 0.7, 40, 16.0f){

            public boolean func_75250_a() {
                return !HunterIllagerEntity.this.isHolding(Items.field_151031_f) && HunterIllagerEntity.this.isHolding(HunterItems.BOOMERANG) && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(3, (Goal)new RangedBowAttackGoal((MonsterEntity)this, 0.7, 25, 15.0f){

            public boolean func_75250_a() {
                return HunterIllagerEntity.this.isHolding(Items.field_151031_f) && !HunterIllagerEntity.this.isHolding(HunterItems.BOOMERANG) && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(4, new MoveToFoodGoal<HunterIllagerEntity>(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new WakeUpGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new GotoBedGoal(this, 0.7));
        this.field_70714_bg.func_75776_a(8, (Goal)new MoveToGoal(this, 10.0, 0.7));
        this.field_70714_bg.func_75776_a(9, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.65));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AnimalEntity.class, 10, true, false, animalTarget){

            public boolean func_75250_a() {
                return super.func_75250_a() && !HunterIllagerEntity.this.func_213657_el() && !HunterIllagerEntity.this.isCooldown();
            }
        }.func_190882_b(300));
    }

    public static AttributeModifierMap.MutableAttribute getAttributeMap() {
        return MonsterEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, (double)0.35f).func_233815_a_(Attributes.field_233818_a_, 26.0).func_233815_a_(Attributes.field_233819_b_, 22.0).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason spawnreason, @Nullable ILivingEntityData entitydata, @Nullable CompoundNBT compound) {
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        if (spawnreason != SpawnReason.MOB_SUMMONED) {
            this.inventory.func_174894_a(new ItemStack((IItemProvider)Items.field_151147_al, 3));
        }
        return super.func_213386_a(world, difficulty, spawnreason, entitydata, compound);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        if (this.field_70170_p.field_73012_v.nextFloat() < 0.6f) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151031_f));
        } else {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)HunterItems.BOOMERANG));
            this.inventory.func_174894_a(new ItemStack((IItemProvider)HunterItems.BOOMERANG));
        }
    }

    protected void func_180483_b(DifficultyInstance difficulty) {
        float f = difficulty.func_180170_c();
        if (!this.func_184614_ca().func_190926_b() && this.field_70146_Z.nextFloat() < 0.3f * f) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)this.func_184614_ca(), (int)((int)(5.0f + f * (float)this.field_70146_Z.nextInt(18))), (boolean)false));
        } else if (!this.func_184614_ca().func_190926_b() && this.field_70146_Z.nextFloat() < 0.3f) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)this.func_184614_ca(), (int)((int)(5.0f + (float)this.field_70146_Z.nextInt(10))), (boolean)false));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_EATING, (Object)false);
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
        boolean flag3;
        ItemStack itemstack = new ItemStack((IItemProvider)Items.field_151031_f);
        Raid raid = this.func_213663_ek();
        int i = 1;
        if (p_213660_1_ > raid.func_221306_a(Difficulty.NORMAL)) {
            i = 2;
        }
        boolean flag = this.field_70146_Z.nextFloat() <= raid.func_221308_w();
        boolean bl = flag3 = (double)this.field_70146_Z.nextFloat() <= 0.2;
        if (flag) {
            HashMap map = Maps.newHashMap();
            map.put(Enchantments.field_185309_u, i);
            EnchantmentHelper.func_82782_a((Map)map, (ItemStack)itemstack);
        }
        if (flag3) {
            this.inventory.func_174894_a(new ItemStack((IItemProvider)Items.field_151153_ao, 1));
        }
        this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.homePosition != null) {
            compound.func_218657_a("HomeTarget", (INBT)NBTUtil.func_186859_a((BlockPos)this.homePosition));
        }
        compound.func_74768_a("CooldownTicks", this.cooldownTicks);
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            listnbt.add((Object)itemstack.func_77955_b(new CompoundNBT()));
        }
        compound.func_218657_a("Inventory", (INBT)listnbt);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("HomeTarget")) {
            this.homePosition = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("HomeTarget"));
        }
        this.cooldownTicks = compound.func_74762_e("CooldownTicks");
        ListNBT listnbt = compound.func_150295_c("Inventory", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)listnbt.func_150305_b(i));
            if (itemstack.func_190926_b()) continue;
            this.inventory.func_174894_a(itemstack);
        }
        this.func_98053_h(true);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public boolean needFood() {
        for (int i = 0; i < this.getInventory().func_70302_i_(); ++i) {
            if (!this.getInventory().func_70301_a(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        Item item = itemstack.func_77973_b();
        if (HunterIllagerEntity.isFoods(item)) {
            this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
            ItemStack itemstack1 = this.inventory.func_174894_a(itemstack);
            if (itemstack1.func_190926_b()) {
                itemEntity.func_70106_y();
            } else {
                itemstack.func_190920_e(itemstack1.func_190916_E());
            }
        } else if (item == HunterItems.BOOMERANG) {
            super.func_175445_a(itemEntity);
        }
    }

    private static boolean isFoods(Item item) {
        return item.func_219971_r() && item != Items.field_151070_bp && item != Items.field_196089_aZ;
    }

    public void setMainHome(@Nullable BlockPos p_213726_1_) {
        this.homePosition = p_213726_1_;
    }

    @Nullable
    public BlockPos getMainHome() {
        return this.homePosition;
    }

    public boolean isCooldown() {
        return this.cooldownTicks > 0;
    }

    public int getCooldownTicks() {
        return this.cooldownTicks;
    }

    public void setCooldownTicks(int tick) {
        this.cooldownTicks = tick;
    }

    public void setEatFood(boolean drinkingPotion) {
        this.func_184212_Q().func_187227_b(IS_EATING, (Object)drinkingPotion);
    }

    public boolean isEatFood() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_EATING);
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.field_70146_Z.nextFloat() < 7.5E-4f) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)15);
            }
            if (this.field_70173_aa % 20 == 0) {
                ItemStack boomerang = this.findBoomerang();
                if (this.func_184586_b(Hand.MAIN_HAND).func_190926_b() && boomerang.func_77973_b() == HunterItems.BOOMERANG) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, boomerang.func_77946_l());
                    boomerang.func_190918_g(1);
                }
            }
        }
        super.func_70636_d();
    }

    public ItemStack findFood() {
        int i = 0;
        if (i < this.inventory.func_70302_i_()) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (!stack.func_190926_b()) {
                if (HunterIllagerEntity.isFoods(stack.func_77973_b())) {
                    return stack;
                }
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    protected ItemStack findBoomerang() {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != HunterItems.BOOMERANG) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public SoundEvent func_213654_dW() {
        return HunterSounds.HUNTER_ILLAGER_LAUGH;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191268_hm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191269_hn;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_191270_ho;
    }

    public void func_70074_a(LivingEntity entity) {
        super.func_70074_a(entity);
        if (!(entity instanceof AbstractIllagerEntity)) {
            this.func_184185_a(HunterSounds.HUNTER_ILLAGER_LAUGH, this.func_70599_aP() + 0.15f, this.func_70647_i());
            this.setCooldownTicks(400);
        }
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.inventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.func_199701_a_(itemstack);
            }
        }
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof BoomerangEntity && ((BoomerangEntity)entityIn).func_234616_v_() == this) {
            ((BoomerangEntity)entityIn).func_70106_y();
            this.func_184611_a(Hand.MAIN_HAND, ((BoomerangEntity)entityIn).getBoomerang());
        }
        super.func_82167_n(entityIn);
    }

    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("hunterillager", "entity/hunter_illager");
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        ItemStack main = this.func_184614_ca();
        ItemStack off = this.func_184592_cb();
        if (main.func_77973_b() instanceof BowItem || off.func_77973_b() instanceof BowItem) {
            ItemStack itemstack = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f)));
            AbstractArrowEntity abstractarrowentity = ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)itemstack, (float)(distanceFactor * 1.15f));
            if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
                abstractarrowentity = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(abstractarrowentity);
            }
            double d0 = target.func_226277_ct_() - this.func_226277_ct_();
            double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - abstractarrowentity.func_226278_cu_();
            double d2 = target.func_226281_cx_() - this.func_226281_cx_();
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            abstractarrowentity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(10 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
            this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_217376_c((Entity)abstractarrowentity);
        } else {
            this.func_184185_a(SoundEvents.field_187511_aA, 1.0f, 1.0f);
            if (main.func_77973_b() instanceof BoomerangItem) {
                BoomerangEntity projectile = new BoomerangEntity(this.field_70170_p, (LivingEntity)this, main.func_77946_l());
                projectile.func_234612_a_((Entity)this, this.field_70125_A, this.field_70759_as, 0.0f, 1.0f, 1.0f);
                this.field_70170_p.func_217376_c((Entity)projectile);
                main.func_190918_g(1);
            } else if (off.func_77973_b() instanceof BoomerangItem) {
                BoomerangEntity projectile = new BoomerangEntity(this.field_70170_p, (LivingEntity)this, off.func_77946_l());
                projectile.func_234612_a_((Entity)this, this.field_70125_A, this.field_70759_as, 0.0f, 1.0f, 1.0f);
                this.field_70170_p.func_217376_c((Entity)projectile);
                off.func_190918_g(1);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractIllagerEntity.ArmPose func_193077_p() {
        if (this.isHolding(Items.field_151031_f) || this.isHolding(HunterItems.BOOMERANG)) {
            return this.func_213398_dR() ? AbstractIllagerEntity.ArmPose.BOW_AND_ARROW : AbstractIllagerEntity.ArmPose.CROSSED;
        }
        return this.func_213398_dR() ? AbstractIllagerEntity.ArmPose.ATTACKING : AbstractIllagerEntity.ArmPose.CROSSED;
    }

    private boolean isHolding(Item item) {
        ItemStack main = this.func_184614_ca();
        ItemStack off = this.func_184592_cb();
        return main.func_77973_b() == item || off.func_77973_b() == item;
    }

    public static class MoveToFoodGoal<T extends HunterIllagerEntity>
    extends Goal {
        private final T illager;
        private ItemEntity targetItem;

        public MoveToFoodGoal(T p_i50572_2_) {
            this.illager = p_i50572_2_;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            List list;
            if (this.illager.func_70681_au().nextInt(10) == 0 && ((HunterIllagerEntity)((Object)this.illager)).needFood() && !(list = ((HunterIllagerEntity)((Object)this.illager)).field_70170_p.func_175647_a(ItemEntity.class, this.illager.func_174813_aQ().func_72314_b(16.0, 8.0, 16.0), food)).isEmpty()) {
                this.targetItem = (ItemEntity)list.get(this.illager.func_70681_au().nextInt(list.size()));
                return this.illager.func_70661_as().func_75497_a((Entity)this.targetItem, 0.85);
            }
            return false;
        }

        public void func_75246_d() {
            if (this.illager.func_70661_as().func_208485_j().func_218137_a((IPosition)this.illager.func_213303_ch(), 1.414) && this.targetItem != null && this.targetItem.func_70089_S()) {
                ((HunterIllagerEntity)((Object)this.illager)).func_175445_a(this.targetItem);
            }
        }
    }

    class MoveToGoal
    extends Goal {
        final HunterIllagerEntity hunterIllager;
        final double field_220848_b;
        final double speed;

        MoveToGoal(HunterIllagerEntity hunterillager, double distance, double speed) {
            this.hunterIllager = hunterillager;
            this.field_220848_b = distance;
            this.speed = speed;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public void func_75251_c() {
            HunterIllagerEntity.this.field_70699_by.func_75499_g();
        }

        public boolean func_75250_a() {
            BlockPos blockpos = this.hunterIllager.getMainHome();
            return blockpos != null && this.func_220846_a(blockpos, this.hunterIllager.field_70170_p.func_72935_r() ? this.field_220848_b : this.field_220848_b * (double)0.8f) && !HunterIllagerEntity.this.func_213657_el();
        }

        public void func_75246_d() {
            BlockPos blockpos = this.hunterIllager.getMainHome();
            if (blockpos != null && HunterIllagerEntity.this.field_70699_by.func_75500_f()) {
                if (this.func_220846_a(blockpos, 10.0)) {
                    Vector3d vec3d = new Vector3d((double)blockpos.func_177958_n() - this.hunterIllager.func_226277_ct_(), (double)blockpos.func_177956_o() - this.hunterIllager.func_226278_cu_(), (double)blockpos.func_177952_p() - this.hunterIllager.func_226281_cx_()).func_72432_b();
                    Vector3d vec3d1 = vec3d.func_186678_a(10.0).func_72441_c(this.hunterIllager.func_226277_ct_(), this.hunterIllager.func_226278_cu_(), this.hunterIllager.func_226281_cx_());
                    HunterIllagerEntity.this.field_70699_by.func_75492_a(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, this.speed);
                } else {
                    HunterIllagerEntity.this.field_70699_by.func_75492_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), this.speed);
                }
            }
        }

        private boolean func_220846_a(BlockPos p_220846_1_, double p_220846_2_) {
            return !p_220846_1_.func_218137_a((IPosition)this.hunterIllager.func_213303_ch(), p_220846_2_);
        }
    }
}

