/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import me.hypherionmc.hyperlighting.common.containers.ContainerSwitchBoard;
import me.hypherionmc.hyperlighting.common.tile.TileSwitchBoard;
import me.hypherionmc.hyperlighting.util.SwitchBoardHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class GuiSwitchBoard
extends ContainerScreen<ContainerSwitchBoard> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("hyperlighting:textures/gui/switchboard_gui.png");
    private final PlayerInventory player;
    private final TileSwitchBoard te;
    private ImageButton buttonImage;
    private List<SwitchBoardHelper> slots = new ArrayList<SwitchBoardHelper>();

    public GuiSwitchBoard(ContainerSwitchBoard containerSwitchBoard, PlayerInventory inventory, ITextComponent title) {
        super((Container)containerSwitchBoard, inventory, title);
        this.player = inventory;
        this.te = containerSwitchBoard.getTe();
        this.slots.add(new SwitchBoardHelper(new Vector2f(17.0f, 36.0f), new Vector2f(24.0f, 32.0f), new Vector2f(29.0f, 32.0f), new Vector2f(43.0f, 14.0f)));
        this.slots.add(new SwitchBoardHelper(new Vector2f(66.0f, 36.0f), new Vector2f(73.0f, 32.0f), new Vector2f(78.0f, 32.0f), new Vector2f(92.0f, 14.0f)));
        this.slots.add(new SwitchBoardHelper(new Vector2f(115.0f, 36.0f), new Vector2f(122.0f, 32.0f), new Vector2f(127.0f, 32.0f), new Vector2f(141.0f, 14.0f)));
        this.slots.add(new SwitchBoardHelper(new Vector2f(17.0f, 66.0f), new Vector2f(24.0f, 62.0f), new Vector2f(29.0f, 62.0f), new Vector2f(43.0f, 44.0f)));
        this.slots.add(new SwitchBoardHelper(new Vector2f(66.0f, 66.0f), new Vector2f(73.0f, 62.0f), new Vector2f(78.0f, 62.0f), new Vector2f(92.0f, 44.0f)));
        this.slots.add(new SwitchBoardHelper(new Vector2f(115.0f, 66.0f), new Vector2f(122.0f, 62.0f), new Vector2f(127.0f, 62.0f), new Vector2f(141.0f, 44.0f)));
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int id = 0;
        for (SwitchBoardHelper itm : this.slots) {
            int finalId = id++;
            this.buttonImage = new ImageButton(this.field_147003_i + (int)itm.getButtonPos().field_189982_i, this.field_147009_r + (int)itm.getButtonPos().field_189983_j, 16, 16, 176, 0, 0, TEXTURE, button -> this.actionPerformed(button, finalId));
            this.func_230480_a_((Widget)this.buttonImage);
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        GuiUtils.drawTexturedModalRect((int)this.field_147003_i, (int)this.field_147009_r, (int)0, (int)0, (int)this.field_146999_f, (int)this.field_147000_g, (float)0.0f);
        for (int j = 0; j < 6; ++j) {
            if (!((Slot)((ContainerSwitchBoard)this.func_212873_a_()).field_75151_b.get(j)).func_75216_d() || !this.te.isLinked(j)) continue;
            int i = this.te.getPowerLevel(j);
            SwitchBoardHelper helper = this.slots.get(j);
            GuiUtils.drawTexturedModalRect((int)(this.field_147003_i + (int)helper.getBarPos().field_189982_i), (int)(this.field_147009_r + (int)helper.getBarPos().field_189983_j - i + 1), (int)176, (int)(39 - i), (int)4, (int)(i + 1), (float)1.0f);
            if (this.te.getCharging(j)) {
                GuiUtils.drawTexturedModalRect((int)(this.field_147003_i + (int)helper.getChargePos().field_189982_i), (int)(this.field_147009_r + (int)helper.getChargePos().field_189983_j), (int)189, (int)17, (int)4, (int)4, (float)2.0f);
            }
            if (this.te.getState(j)) {
                GuiUtils.drawTexturedModalRect((int)(this.field_147003_i + (int)helper.getStatepos().field_189982_i), (int)(this.field_147009_r + (int)helper.getStatepos().field_189983_j), (int)181, (int)17, (int)4, (int)4, (float)3.0f);
                continue;
            }
            GuiUtils.drawTexturedModalRect((int)(this.field_147003_i + (int)helper.getStatepos().field_189982_i), (int)(this.field_147009_r + (int)helper.getStatepos().field_189983_j), (int)185, (int)17, (int)4, (int)4, (float)3.0f);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrixStack, this.player.func_145748_c_().getString(), 7.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        for (int i = 0; i < this.slots.size(); ++i) {
            if (!((Slot)((ContainerSwitchBoard)this.field_147002_h).field_75151_b.get(i)).func_75216_d() || !this.te.isLinked(i)) continue;
            SwitchBoardHelper helper = this.slots.get(i);
            this.drawPowerToolTip(matrixStack, mouseX, mouseY, this.field_147003_i + (int)helper.getBarPos().field_189982_i, this.field_147009_r + (int)helper.getBarPos().field_189983_j - 22, 4, 23, "Battery Level", TextFormatting.YELLOW + "" + Math.round(this.te.getPowerLevelPer(i)) + "%");
            this.drawPowerToolTip(matrixStack, mouseX, mouseY, this.field_147003_i + (int)helper.getChargePos().field_189982_i, this.field_147009_r + (int)helper.getChargePos().field_189983_j, 4, 4, "Charging State", this.te.getCharging(i) ? TextFormatting.GREEN + "Charging" : TextFormatting.RED + "Not Charging");
            this.drawPowerToolTip(matrixStack, mouseX, mouseY, this.field_147003_i + (int)helper.getStatepos().field_189982_i, this.field_147009_r + (int)helper.getStatepos().field_189983_j, 4, 4, "Power State", this.te.getState(i) ? TextFormatting.GREEN + "On" : TextFormatting.RED + "Off");
        }
    }

    private void drawPowerToolTip(MatrixStack stack, int mouseX, int mouseY, int startX, int startY, int sizeX, int sizeY, String title, String description) {
        int k = (this.field_230708_k_ - this.field_146999_f) / 2;
        int l = (this.field_230709_l_ - this.field_147000_g) / 2;
        if (mouseX > startX && mouseX < startX + sizeX && mouseY > startY && mouseY < startY + sizeY) {
            ArrayList<TranslationTextComponent> list = new ArrayList<TranslationTextComponent>();
            list.add(new TranslationTextComponent(title));
            list.add(new TranslationTextComponent(description));
            GuiUtils.drawHoveringText((MatrixStack)stack, list, (int)(mouseX - k), (int)(mouseY - l), (int)this.field_230708_k_, (int)this.field_230709_l_, (int)200, (FontRenderer)this.field_230712_o_);
        }
    }

    protected void actionPerformed(Button button, int bid) {
        switch (bid) {
            case 0: {
                if (!((Slot)((ContainerSwitchBoard)this.field_147002_h).field_75151_b.get(0)).func_75216_d()) break;
                this.te.toggleState(0);
                break;
            }
            case 1: {
                if (!((Slot)((ContainerSwitchBoard)this.field_147002_h).field_75151_b.get(1)).func_75216_d()) break;
                this.te.toggleState(1);
                break;
            }
            case 2: {
                if (!((Slot)((ContainerSwitchBoard)this.field_147002_h).field_75151_b.get(2)).func_75216_d()) break;
                this.te.toggleState(2);
                break;
            }
            case 3: {
                if (!((Slot)((ContainerSwitchBoard)this.field_147002_h).field_75151_b.get(3)).func_75216_d()) break;
                this.te.toggleState(3);
                break;
            }
            case 4: {
                if (!((Slot)((ContainerSwitchBoard)this.field_147002_h).field_75151_b.get(4)).func_75216_d()) break;
                this.te.toggleState(4);
                break;
            }
            case 5: {
                if (!((Slot)((ContainerSwitchBoard)this.field_147002_h).field_75151_b.get(5)).func_75216_d()) break;
                this.te.toggleState(5);
            }
        }
    }
}

