/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.blocks;

import java.util.List;
import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.HyperLighting;
import me.hypherionmc.hyperlighting.api.DyeAble;
import me.hypherionmc.hyperlighting.api.RemoteSwitchable;
import me.hypherionmc.hyperlighting.common.config.HyperLightingConfig;
import me.hypherionmc.hyperlighting.common.init.HLItems;
import me.hypherionmc.hyperlighting.common.items.BlockItemColor;
import me.hypherionmc.hyperlighting.common.network.PacketHandler;
import me.hypherionmc.hyperlighting.common.network.packets.OpenGUIPacket;
import me.hypherionmc.hyperlighting.common.tile.TileBatteryNeon;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BatteryNeon
extends ContainerBlock
implements RemoteSwitchable,
DyeAble {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    private static final VoxelShape DOWN_BOUNDING_BOX = Block.func_208617_a((double)0.0, (double)0.0, (double)7.008, (double)16.0, (double)3.008, (double)8.992);
    private static final VoxelShape UP_BOUNDING_BOX = Block.func_208617_a((double)0.0, (double)12.8, (double)7.008, (double)16.0, (double)16.0, (double)8.992);
    private static final VoxelShape SOUTH_BOUNDING_BOX = Block.func_208617_a((double)0.0, (double)7.008, (double)12.992, (double)16.0, (double)8.992, (double)16.0);
    private static final VoxelShape EAST_BOUNDING_BOX = Block.func_208617_a((double)16.0, (double)7.008, (double)0.0, (double)12.8, (double)8.992, (double)16.0);
    private static final VoxelShape WEST_BOUNDING_BOX = Block.func_208617_a((double)0.0, (double)7.008, (double)0.0, (double)3.2, (double)8.992, (double)16.0);
    private static final VoxelShape NORTH_BOUNDING_BOX = Block.func_208617_a((double)0.0, (double)7.008, (double)0.336, (double)16.0, (double)8.992, (double)3.328);

    public BatteryNeon(String name) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200947_a(SoundType.field_185853_f));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)LIT, (Comparable)HyperLightingConfig.batteryOnByDefault.get()));
        HLItems.ITEMS.register(name, () -> new BlockItemColor((Block)this, new Item.Properties().func_200916_a((ItemGroup)HyperLighting.mainTab)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case UP: {
                return DOWN_BOUNDING_BOX;
            }
            default: {
                return UP_BOUNDING_BOX;
            }
            case NORTH: {
                return SOUTH_BOUNDING_BOX;
            }
            case EAST: {
                return WEST_BOUNDING_BOX;
            }
            case WEST: {
                return EAST_BOUNDING_BOX;
            }
            case SOUTH: 
        }
        return NORTH_BOUNDING_BOX;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K && !Screen.func_231172_r_()) {
            if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
                BlockState oldState = state;
                state = (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false));
                worldIn.func_180501_a(pos, state, 3);
                worldIn.func_184138_a(pos, oldState, state, 4);
                return ActionResultType.CONSUME;
            }
            if (worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof TileBatteryNeon && ((TileBatteryNeon)worldIn.func_175625_s(pos)).getPowerLevel() > 0) {
                BlockState oldState = state;
                state = (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true));
                worldIn.func_180501_a(pos, state, 3);
                worldIn.func_184138_a(pos, oldState, state, 4);
                return ActionResultType.CONSUME;
            }
            BlockState oldState = state;
            state = (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false));
            worldIn.func_180501_a(pos, state, 3);
            worldIn.func_184138_a(pos, oldState, state, 4);
            player.func_146105_b((ITextComponent)new StringTextComponent("Out of power"), true);
            return ActionResultType.CONSUME;
        }
        if (Screen.func_231172_r_()) {
            OpenGUIPacket openGUIPacket = new OpenGUIPacket(11, pos);
            PacketHandler.INSTANCE.sendToServer((Object)openGUIPacket);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.CONSUME;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT, FACING});
        super.func_206840_a(builder);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)LIT) != false ? 15 : 0;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l())).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileBatteryNeon();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Override
    public IBlockColor dyeHandler() {
        return (state, world, pos, tintIndex) -> {
            if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
                if (world != null && world.func_175625_s(pos) instanceof TileBatteryNeon) {
                    TileBatteryNeon tileBatteryNeon = (TileBatteryNeon)world.func_175625_s(pos);
                    return tileBatteryNeon.getDyeHandler().getStackInSlot(0).func_77973_b() instanceof DyeItem ? ((DyeItem)tileBatteryNeon.getDyeHandler().getStackInSlot(0).func_77973_b()).func_195962_g().getColorValue() : DyeColor.WHITE.getColorValue();
                }
            } else {
                return DyeColor.BLACK.getColorValue();
            }
            return DyeColor.BLACK.getColorValue();
        };
    }

    @Override
    public DyeColor defaultDyeColor() {
        return DyeColor.WHITE;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileBatteryNeon) {
            TileBatteryNeon tileBatteryNeon = (TileBatteryNeon)world.func_175625_s(pos);
            tileBatteryNeon.dropInventory();
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    @Override
    public BlockState remoteSwitched(BlockState state, BlockPos pos, World world) {
        return (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)LIT) == false));
    }

    @Override
    public boolean getPoweredState(BlockState state) {
        return (Boolean)state.func_177229_b((Property)LIT);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Dyable"));
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Color: " + this.defaultDyeColor().name()));
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Colored Lighting Supported"));
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }
}

