/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.blocks;

import java.util.List;
import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.api.DyeAble;
import me.hypherionmc.hyperlighting.common.init.HLItems;
import me.hypherionmc.hyperlighting.common.items.BlockItemColor;
import me.hypherionmc.hyperlighting.util.ModUtils;
import me.hypherionmc.rgblib.api.ColoredLightManager;
import me.hypherionmc.rgblib.api.RGBLight;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ColoredGlowstone
extends Block
implements DyeAble {
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.func_177709_a((String)"color", DyeColor.class);

    public ColoredGlowstone(String name, DyeColor color, ItemGroup group) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200947_a(SoundType.field_185853_f).func_200943_b(0.3f));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(COLOR, (Comparable)color));
        if (ModUtils.isRGBLibPresent()) {
            ColoredLightManager.registerProvider((Block)this, this::produceColoredLight);
        }
        HLItems.ITEMS.register(name, () -> new BlockItemColor(this, new Item.Properties().func_200916_a(group)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{COLOR});
        super.func_206840_a(builder);
    }

    @Override
    public IBlockColor dyeHandler() {
        return (state, world, pos, tintIndex) -> ((DyeColor)state.func_177229_b(COLOR)).getColorValue();
    }

    @Override
    public DyeColor defaultDyeColor() {
        return (DyeColor)this.func_176223_P().func_177229_b(COLOR);
    }

    private RGBLight produceColoredLight(BlockPos pos, BlockState state) {
        return RGBLight.builder().pos(pos).color(((DyeColor)state.func_177229_b(COLOR)).getColorValue(), false).radius(15.0f).build();
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return 15;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Dyable"));
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Color: " + this.defaultDyeColor().name()));
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Colored Lighting Supported"));
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K && !player.func_184586_b(handIn).func_190926_b() && player.func_184586_b(handIn).func_77973_b() instanceof DyeItem) {
            state = (BlockState)state.func_206870_a(COLOR, (Comparable)((DyeItem)player.func_184586_b(handIn).func_77973_b()).func_195962_g());
            worldIn.func_180501_a(pos, state, 3);
            worldIn.func_184138_a(pos, state, state, 3);
            if (!player.func_184812_l_()) {
                ItemStack stack = player.func_184586_b(handIn);
                stack.func_190918_g(1);
                player.func_184611_a(handIn, stack);
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }
}

