/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.blocks;

import java.util.List;
import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.api.DyeAble;
import me.hypherionmc.hyperlighting.api.RemoteSwitchable;
import me.hypherionmc.hyperlighting.common.config.HyperLightingConfig;
import me.hypherionmc.hyperlighting.common.init.HLItems;
import me.hypherionmc.hyperlighting.common.items.BlockItemColor;
import me.hypherionmc.hyperlighting.common.tile.TileSolarLight;
import me.hypherionmc.hyperlighting.util.ModUtils;
import me.hypherionmc.rgblib.api.ColoredLightManager;
import me.hypherionmc.rgblib.api.RGBLight;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class FenceSolar
extends ContainerBlock
implements RemoteSwitchable,
DyeAble {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    private static final VoxelShape BOUNDING_BOX = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.992, (double)10.0);
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.func_177709_a((String)"color", DyeColor.class);

    public FenceSolar(String name, DyeColor color, ItemGroup group) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200946_b());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)LIT, (Comparable)HyperLightingConfig.batteryOnByDefault.get())).func_206870_a(COLOR, (Comparable)color));
        if (ModUtils.isRGBLibPresent()) {
            ColoredLightManager.registerProvider((Block)this, this::produceColoredLight);
        }
        HLItems.ITEMS.register(name, () -> new BlockItemColor((Block)this, new Item.Properties().func_200916_a(group)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BOUNDING_BOX;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT, COLOR});
        super.func_206840_a(builder);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            if (!player.func_184586_b(handIn).func_190926_b() && player.func_184586_b(handIn).func_77973_b() instanceof DyeItem) {
                state = (BlockState)state.func_206870_a(COLOR, (Comparable)((DyeItem)player.func_184586_b(handIn).func_77973_b()).func_195962_g());
                worldIn.func_180501_a(pos, state, 3);
                worldIn.func_184138_a(pos, state, state, 3);
                if (!player.func_184812_l_()) {
                    ItemStack stack = player.func_184586_b(handIn);
                    stack.func_190918_g(1);
                    player.func_184611_a(handIn, stack);
                }
                return ActionResultType.CONSUME;
            }
            BlockState oldState = state;
            if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
                state = (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false));
                worldIn.func_180501_a(pos, state, 3);
            } else if (worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof TileSolarLight && ((TileSolarLight)worldIn.func_175625_s(pos)).getPowerLevel() > 0) {
                state = (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true));
                worldIn.func_180501_a(pos, state, 3);
                worldIn.func_184138_a(pos, oldState, state, 4);
            } else {
                state = (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false));
                worldIn.func_180501_a(pos, state, 3);
                worldIn.func_184138_a(pos, oldState, state, 4);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("Out of power"), true);
            }
        }
        return ActionResultType.CONSUME;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)LIT) != false ? 14 : 0;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileSolarLight();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    private RGBLight produceColoredLight(BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && !((Boolean)HyperLightingConfig.batteryColor.get()).booleanValue()) {
            return RGBLight.builder().pos(pos).color(((DyeColor)state.func_177229_b(COLOR)).getColorValue(), false).radius(15.0f).build();
        }
        return null;
    }

    @Override
    public IBlockColor dyeHandler() {
        return (state, world, pos, tintIndex) -> {
            if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
                return ((DyeColor)state.func_177229_b(COLOR)).getColorValue();
            }
            return DyeColor.BLACK.getColorValue();
        };
    }

    @Override
    public DyeColor defaultDyeColor() {
        return (DyeColor)this.func_176223_P().func_177229_b(COLOR);
    }

    @Override
    public BlockState remoteSwitched(BlockState state, BlockPos pos, World world) {
        return (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)LIT) == false));
    }

    @Override
    public boolean getPoweredState(BlockState state) {
        return (Boolean)state.func_177229_b((Property)LIT);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Dyable"));
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Color: " + this.defaultDyeColor().name()));
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Colored Lighting Supported"));
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }
}

