/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.blocks;

import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.HyperLighting;
import me.hypherionmc.hyperlighting.common.containers.ContainerSwitchBoard;
import me.hypherionmc.hyperlighting.common.init.HLItems;
import me.hypherionmc.hyperlighting.common.tile.TileSwitchBoard;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class SwitchBoard
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final VoxelShape BOUNDING_BOX = Block.func_208617_a((double)0.0, (double)0.0, (double)12.992, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.008);
    private static final VoxelShape AABB_EAST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.008, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_WEST = Block.func_208617_a((double)12.992, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SwitchBoard(String name) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
        HLItems.ITEMS.register(name, () -> new BlockItem((Block)this, new Item.Properties().func_200916_a((ItemGroup)HyperLighting.machinesTab)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileSwitchBoard();
    }

    public ActionResultType func_225533_a_(BlockState state, final World worldIn, final BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileEntity;
        if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileSwitchBoard) {
            INamedContainerProvider containerProvider = new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent("container.switchboard");
                }

                public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                    return new ContainerSwitchBoard(i, worldIn, pos, playerInventory, playerEntity);
                }
            };
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)containerProvider, (BlockPos)tileEntity.func_174877_v());
        }
        return ActionResultType.CONSUME;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case EAST: {
                return AABB_EAST;
            }
            case WEST: {
                return AABB_WEST;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
        }
        return BOUNDING_BOX;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195999_j().func_174811_aO().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
        super.func_206840_a(builder);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileSwitchBoard) {
            ((TileSwitchBoard)world.func_175625_s(pos)).dropInventory();
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }
}

