/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.api.DyeAble;
import me.hypherionmc.hyperlighting.api.Lightable;
import me.hypherionmc.hyperlighting.common.config.HyperLightingConfig;
import me.hypherionmc.hyperlighting.common.handlers.ParticleRegistryHandler;
import me.hypherionmc.hyperlighting.common.init.HLItems;
import me.hypherionmc.hyperlighting.common.items.BlockItemColor;
import me.hypherionmc.hyperlighting.util.ModUtils;
import me.hypherionmc.rgblib.api.ColoredLightManager;
import me.hypherionmc.rgblib.api.RGBLight;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class TikiTorch
extends Block
implements DyeAble,
Lightable {
    public static BooleanProperty LIT = BlockStateProperties.field_208190_q;
    protected static final VoxelShape STANDING_AABB = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.func_177709_a((String)"color", DyeColor.class);

    public TikiTorch(String name, DyeColor color, ItemGroup group) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200946_b());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)LIT, (Comparable)HyperLightingConfig.tikiOnByDefault.get())).func_206870_a(COLOR, (Comparable)color));
        if (ModUtils.isRGBLibPresent()) {
            ColoredLightManager.registerProvider((Block)this, this::produceColoredLight);
        }
        HLItems.ITEMS.register(name, () -> new BlockItemColor(this, new Item.Properties().func_200916_a(group)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return STANDING_AABB;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT, COLOR});
        super.func_206840_a(builder);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean isValidPosition(BlockState state, IWorldReader worldIn, BlockPos pos, Direction direction) {
        return TikiTorch.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177977_b(), (Direction)direction);
    }

    @Override
    public void toggleLight(World worldIn, BlockState state, BlockPos pos) {
        state = (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)LIT) == false));
        worldIn.func_180501_a(pos, state, 2);
        if (!((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.3f, 1.0f);
        }
        worldIn.func_195593_d(pos, (Block)this);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)LIT) != false ? 15 : 0;
    }

    private RGBLight produceColoredLight(BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && !((Boolean)HyperLightingConfig.tikiColor.get()).booleanValue()) {
            return RGBLight.builder().pos(pos).color(((DyeColor)state.func_177229_b(COLOR)).getColorValue(), false).radius(15.0f).build();
        }
        return null;
    }

    @Override
    public IBlockColor dyeHandler() {
        return (state, world, pos, tintIndex) -> {
            if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
                return ((DyeColor)state.func_177229_b(COLOR)).getColorValue();
            }
            return DyeColor.BLACK.getColorValue();
        };
    }

    @Override
    public DyeColor defaultDyeColor() {
        return (DyeColor)this.func_176223_P().func_177229_b(COLOR);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K && !player.func_184586_b(handIn).func_190926_b() && player.func_184586_b(handIn).func_77973_b() instanceof DyeItem) {
            state = (BlockState)state.func_206870_a(COLOR, (Comparable)((DyeItem)player.func_184586_b(handIn).func_77973_b()).func_195962_g());
            worldIn.func_180501_a(pos, state, 3);
            worldIn.func_184138_a(pos, state, state, 3);
            if (!player.func_184812_l_()) {
                ItemStack stack = player.func_184586_b(handIn);
                stack.func_190918_g(1);
                player.func_184611_a(handIn, stack);
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue()) {
            DyeColor color = (DyeColor)stateIn.func_177229_b(COLOR);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 0.6;
            double d2 = (double)pos.func_177952_p() + 0.5;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1 + (double)0.4f, d2, 0.0, 0.0, 0.0);
            worldIn.func_195594_a((IParticleData)ParticleRegistryHandler.CUSTOM_FLAME.get(), d0, d1 + (double)0.4f, d2, (double)color.func_193349_f()[0], (double)color.func_193349_f()[1], (double)color.func_193349_f()[2]);
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Dyable"));
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Color: " + this.defaultDyeColor().name()));
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Colored Lighting Supported"));
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }
}

