/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.network.packets;

import java.util.function.Supplier;
import me.hypherionmc.hyperlighting.common.containers.ContainerBatteryNeon;
import me.hypherionmc.hyperlighting.common.tile.TileBatteryNeon;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class OpenGUIPacket {
    private BlockPos posToSet;
    private int guiid;

    public OpenGUIPacket(PacketBuffer buffer) {
        this.posToSet = buffer.func_179259_c();
        this.guiid = buffer.readInt();
    }

    public OpenGUIPacket(int guiid, BlockPos pos) {
        this.guiid = guiid;
        this.posToSet = pos;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.posToSet);
        buf.writeInt(this.guiid);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            final TileEntity te = ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q().func_175625_s(this.posToSet);
            INamedContainerProvider containerProvider = new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    if (te instanceof TileBatteryNeon) {
                        return new TranslationTextComponent("container.batteryneon");
                    }
                    return null;
                }

                public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                    if (te instanceof TileBatteryNeon) {
                        return new ContainerBatteryNeon(i, te.func_145831_w(), OpenGUIPacket.this.posToSet, playerInventory, playerEntity);
                    }
                    return null;
                }
            };
            if (containerProvider.func_145748_c_() != null) {
                NetworkHooks.openGui((ServerPlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), (INamedContainerProvider)containerProvider, (BlockPos)te.func_174877_v());
            }
        });
        return true;
    }
}

