/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.api.SolarLight;
import me.hypherionmc.hyperlighting.api.energy.IEnergyContainerItem;
import me.hypherionmc.hyperlighting.api.energy.SolarEnergyStorage;
import me.hypherionmc.hyperlighting.common.blocks.BatteryNeon;
import me.hypherionmc.hyperlighting.common.config.HyperLightingConfig;
import me.hypherionmc.hyperlighting.common.init.HLBlocks;
import me.hypherionmc.hyperlighting.common.init.HLItems;
import me.hypherionmc.hyperlighting.common.init.HLTileEntities;
import me.hypherionmc.hyperlighting.common.tile.TileSolarPanel;
import me.hypherionmc.hyperlighting.util.ModUtils;
import me.hypherionmc.rgblib.api.ColoredLightManager;
import me.hypherionmc.rgblib.api.RGBLight;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;

public class TileBatteryNeon
extends TileEntity
implements ITickableTileEntity,
SolarLight {
    private boolean isCharging = false;
    private final SolarEnergyStorage energyStorage = new SolarEnergyStorage(500, 20, 1);
    private final ItemStackHandler itemStackHandler = new ItemHandler(1);
    private final ItemStackHandler dyeHandler = new DyeHandler(1);
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);

    public TileBatteryNeon() {
        super((TileEntityType)HLTileEntities.TILE_BATTERY_NEON.get());
        if (ModUtils.isRGBLibPresent()) {
            ColoredLightManager.registerProvider((TileEntity)this, this::produceColoredLight);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                if (!this.itemStackHandler.getStackInSlot(0).func_190926_b() && this.itemStackHandler.getStackInSlot(0).func_77973_b() == HLItems.WIRELESS_POWERCARD.get()) {
                    TileSolarPanel storage1;
                    BlockPos pos;
                    CompoundNBT tagCompound;
                    ItemStack stack = this.itemStackHandler.getStackInSlot(0);
                    if (stack.func_77942_o() && stack.func_77978_p() != null && (tagCompound = stack.func_77978_p()).func_74764_b("blockx") && tagCompound.func_74764_b("blocky") && tagCompound.func_74764_b("blockz") && this.field_145850_b.func_175625_s(pos = new BlockPos(tagCompound.func_74762_e("blockx"), tagCompound.func_74762_e("blocky"), tagCompound.func_74762_e("blockz"))) != null && this.field_145850_b.func_175625_s(pos) instanceof TileSolarPanel && (storage1 = (TileSolarPanel)this.field_145850_b.func_175625_s(pos)) != null && storage1.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
                        IEnergyStorage storage = (IEnergyStorage)storage1.getCapability(CapabilityEnergy.ENERGY).resolve().get();
                        if (storage.canExtract() && storage.extractEnergy(10, true) > 0) {
                            if (this.energyStorage.receiveEnergy(20, true) > 0) {
                                this.isCharging = true;
                                storage.extractEnergy(this.energyStorage.receiveEnergy(20, false), false);
                            } else {
                                this.isCharging = false;
                            }
                        } else {
                            this.isCharging = false;
                        }
                    }
                } else if (!this.itemStackHandler.getStackInSlot(0).func_190926_b() && this.itemStackHandler.getStackInSlot(0).func_77973_b() instanceof IEnergyContainerItem) {
                    IEnergyStorage storage = (IEnergyStorage)this.itemStackHandler.getStackInSlot(0).getCapability(CapabilityEnergy.ENERGY).resolve().get();
                    if (storage.canExtract() && storage.extractEnergy(10, true) > 0) {
                        if (this.energyStorage.receiveEnergy(20, true) > 0) {
                            this.isCharging = true;
                            storage.extractEnergy(this.energyStorage.receiveEnergy(20, false), false);
                        } else {
                            this.isCharging = false;
                        }
                    } else {
                        this.isCharging = false;
                    }
                } else {
                    this.isCharging = false;
                }
            }
            if (this.field_145850_b.func_82737_E() % 40L == 0L && this.field_145850_b.func_180495_p(this.field_174879_c) != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == HLBlocks.BATTERY_NEON.get() && ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)BatteryNeon.LIT)).booleanValue()) {
                this.energyStorage.extractEnergy(1, false);
            }
            this.sendUpdates();
        }
        this.field_145850_b.func_201696_r(this.field_174879_c);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.isCharging = nbt.func_74767_n("isCharging");
        this.energyStorage.readNBT(nbt);
        this.itemStackHandler.deserializeNBT(nbt.func_74775_l("inventory"));
        this.dyeHandler.deserializeNBT(nbt.func_74775_l("dye"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("isCharging", this.isCharging);
        this.energyStorage.writeNBT(compound);
        compound.func_218657_a("inventory", (INBT)this.itemStackHandler.serializeNBT());
        compound.func_218657_a("dye", (INBT)this.dyeHandler.serializeNBT());
        return compound;
    }

    @Override
    public boolean isCharging() {
        return this.isCharging;
    }

    @Override
    public int getMaxPowerLevel() {
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public int getPowerLevel() {
        return this.energyStorage.getEnergyStored();
    }

    private void sendUpdates() {
        this.field_145850_b.func_225319_b(this.field_174879_c, this.func_195044_w(), this.func_195044_w());
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.func_70296_d();
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    public RGBLight produceColoredLight(BlockPos pos) {
        if (!((Boolean)HyperLightingConfig.batteryColor.get()).booleanValue() && this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof BatteryNeon && ((Boolean)this.field_145850_b.func_180495_p(pos).func_177229_b((Property)BatteryNeon.LIT)).booleanValue()) {
            if (!this.dyeHandler.getStackInSlot(0).func_190926_b()) {
                ItemStack stack = this.dyeHandler.getStackInSlot(0);
                float[] color = ((DyeItem)stack.func_77973_b()).func_195962_g().func_193349_f();
                return new RGBLight.Builder().pos(pos).color(color[0], color[1], color[2]).radius(14.0f).build();
            }
            float[] color = DyeColor.WHITE.func_193349_f();
            return new RGBLight.Builder().pos(pos).color(color[0], color[1], color[2]).radius(14.0f).build();
        }
        return null;
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public ItemStackHandler getDyeHandler() {
        return this.dyeHandler;
    }

    public void dropInventory() {
        if (!this.dyeHandler.getStackInSlot(0).func_190926_b()) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.dyeHandler.getStackInSlot(0));
        }
        if (!this.itemStackHandler.getStackInSlot(0).func_190926_b()) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.itemStackHandler.getStackInSlot(0));
        }
    }

    public class DyeHandler
    extends ItemStackHandler {
        public DyeHandler(int size) {
            super(size);
        }

        public void setSize(int size) {
            super.setSize(size);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof DyeItem;
        }
    }

    class ItemHandler
    extends ItemStackHandler {
        public ItemHandler(int size) {
            super(size);
        }

        public void setSize(int size) {
            super.setSize(size);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() == HLItems.WIRELESS_POWERCARD.get();
        }
    }
}

