/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.api.SolarLight;
import me.hypherionmc.hyperlighting.api.energy.SolarEnergyStorage;
import me.hypherionmc.hyperlighting.common.blocks.FenceSolar;
import me.hypherionmc.hyperlighting.common.init.HLTileEntities;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.LightType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileSolarLight
extends TileEntity
implements ITickableTileEntity,
SolarLight {
    private int powerLevel = 0;
    private boolean isCharging = false;
    private final int maxPowerLevel = 500;
    private final SolarEnergyStorage energyStorage = new SolarEnergyStorage(500, 100, 0);
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);

    public TileSolarLight() {
        super((TileEntityType)HLTileEntities.TILE_SOLAR_LIGHT.get());
    }

    public void func_73660_a() {
        Block blockType;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L && (blockType = this.func_195044_w().func_177230_c()) instanceof FenceSolar) {
            BlockState iblockstate;
            BlockState oldState = iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (this.field_145850_b.func_230315_m_().func_218272_d()) {
                int i = this.field_145850_b.func_226658_a_(LightType.SKY, this.field_174879_c) - this.field_145850_b.func_175657_ab();
                float f = this.field_145850_b.func_72929_e(1.0f);
                if (i > 5 && this.powerLevel < this.maxPowerLevel) {
                    float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
                    f += (f1 - f) * 0.2f;
                    i = Math.round((float)i * MathHelper.func_76134_b((float)f));
                    i = MathHelper.func_76125_a((int)i, (int)0, (int)15);
                    this.isCharging = true;
                    this.powerLevel += i;
                } else {
                    this.isCharging = false;
                }
                if (this.powerLevel > this.maxPowerLevel) {
                    this.powerLevel = this.maxPowerLevel;
                }
                if (this.powerLevel < 1) {
                    this.powerLevel = 0;
                }
                if (((Boolean)iblockstate.func_177229_b((Property)FenceSolar.LIT)).booleanValue()) {
                    if (this.powerLevel < 1) {
                        iblockstate = (BlockState)iblockstate.func_206870_a((Property)FenceSolar.LIT, (Comparable)Boolean.valueOf(false));
                        this.field_145850_b.func_180501_a(this.field_174879_c, iblockstate, 3);
                        this.field_145850_b.func_184138_a(this.field_174879_c, oldState, iblockstate, 4);
                    } else {
                        --this.powerLevel;
                    }
                }
            }
            this.sendUpdates();
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.powerLevel = compound.func_74762_e("power");
        this.isCharging = compound.func_74767_n("isCharging");
        this.energyStorage.readNBT(compound.func_74775_l("energyStorage"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("power", this.powerLevel);
        compound.func_74757_a("isCharging", this.isCharging);
        compound.func_218657_a("energyStorage", (INBT)this.energyStorage.writeNBT(compound));
        return compound;
    }

    @Override
    public boolean isCharging() {
        return this.isCharging;
    }

    @Override
    public int getMaxPowerLevel() {
        return this.maxPowerLevel;
    }

    @Override
    public int getPowerLevel() {
        return this.powerLevel;
    }

    private void sendUpdates() {
        this.field_145850_b.func_225319_b(this.field_174879_c, this.func_195044_w(), this.func_195044_w());
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.func_70296_d();
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }
}

