/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.tile;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.api.energy.SolarEnergyStorage;
import me.hypherionmc.hyperlighting.common.blocks.SolarPanel;
import me.hypherionmc.hyperlighting.common.init.HLTileEntities;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.LightType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileSolarPanel
extends TileEntity
implements ITickableTileEntity {
    private final SolarEnergyStorage energyStorage = new SolarEnergyStorage(2000, 0, 1000);
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);

    public TileSolarPanel() {
        super((TileEntityType)HLTileEntities.TILE_SOLAR_PANEL.get());
    }

    public void func_73660_a() {
        Block blockType = this.func_195044_w().func_177230_c();
        if (blockType instanceof SolarPanel) {
            if (this.field_145850_b.func_230315_m_().func_218272_d()) {
                int i = this.field_145850_b.func_226658_a_(LightType.SKY, this.field_174879_c) - this.field_145850_b.func_175657_ab();
                float f = this.field_145850_b.func_72929_e(1.0f);
                if (i > 5 && this.energyStorage.getEnergyStored() < this.energyStorage.getMaxEnergyStored()) {
                    float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
                    f += (f1 - f) * 0.2f;
                    i = Math.round((float)i * MathHelper.func_76134_b((float)f));
                    i = MathHelper.func_76125_a((int)i, (int)0, (int)15);
                    this.energyStorage.receiveEnergyInternal(i, false);
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                for (Direction direction : Direction.values()) {
                    IEnergyStorage storage;
                    direction = direction.func_176734_d();
                    if (this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(direction)) == null || !this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(direction)).getCapability(CapabilityEnergy.ENERGY).isPresent() || !(storage = (IEnergyStorage)this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(direction)).getCapability(CapabilityEnergy.ENERGY).resolve().get()).canReceive() || storage.receiveEnergy(200, true) <= 0 || this.energyStorage.extractEnergy(200, true) <= 0) continue;
                    storage.receiveEnergy(this.energyStorage.extractEnergy(200, false), false);
                }
            }
            this.sendUpdates();
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.energyStorage.readNBT(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.energyStorage.writeNBT(compound);
        return compound;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
    }

    private void sendUpdates() {
        this.field_145850_b.func_225319_b(this.field_174879_c, this.func_195044_w(), this.func_195044_w());
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.func_70296_d();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    void transferEnergyToAllAround() {
        if (!this.canTransferEnergyToAllAround()) {
            return;
        }
        this.getConnectedSides().forEach(side -> this.transferEnergyTo((Direction)side, (int)((float)this.energyStorage.getEnergyStored() / (float)this.getConnectedSides().size()), false));
    }

    boolean canTransferEnergyToAllAround() {
        if (this.func_145831_w().field_72995_K) {
            return false;
        }
        if (!this.energyStorage.canExtract()) {
            return false;
        }
        return this.energyStorage.getEnergyStored() > 0;
    }

    ArrayList<Direction> getConnectedSides() {
        ArrayList<Direction> connectedSides = new ArrayList<Direction>();
        for (Direction side : Direction.values()) {
            if (!this.isConnectedTo(side)) continue;
            connectedSides.add(side);
        }
        return connectedSides;
    }

    int transferEnergyTo(Direction side, int energyToTransfer, boolean simulate) {
        if (!this.canTransferEnergyTo(side, energyToTransfer)) {
            return 0;
        }
        IEnergyStorage storage = (IEnergyStorage)this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(side)).getCapability(CapabilityEnergy.ENERGY, side.func_176734_d()).resolve().get();
        return this.energyStorage.extractEnergy(storage.receiveEnergy(energyToTransfer, simulate), simulate);
    }

    boolean canTransferEnergyTo(Direction side, int energyToTransfer) {
        if (!this.energyStorage.canExtract()) {
            return false;
        }
        if (this.func_145831_w() == null) {
            return false;
        }
        if (this.func_145831_w().field_72995_K) {
            return false;
        }
        if (this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(side)) == null) {
            return false;
        }
        IEnergyStorage storage = (IEnergyStorage)this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(side)).getCapability(CapabilityEnergy.ENERGY, side.func_176734_d()).resolve().get();
        if (storage == null) {
            return false;
        }
        return storage.canReceive();
    }

    boolean isConnectedTo(Direction side) {
        if (this.func_145831_w() == null) {
            return false;
        }
        TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(side));
        if (tile == null) {
            return false;
        }
        return tile.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d()) != null;
    }
}

