/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.api.RemoteSwitchable;
import me.hypherionmc.hyperlighting.api.SolarLight;
import me.hypherionmc.hyperlighting.api.SwitchModule;
import me.hypherionmc.hyperlighting.common.init.HLTileEntities;
import me.hypherionmc.hyperlighting.common.network.PacketHandler;
import me.hypherionmc.hyperlighting.common.network.packets.PacketStateToggle;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileSwitchBoard
extends TileEntity {
    private final ItemStackHandler itemStackHandler = new SwitchItemStackHandler(6);
    private LazyOptional<IItemHandler> storage = LazyOptional.of(() -> this.itemStackHandler);

    public TileSwitchBoard() {
        super((TileEntityType)HLTileEntities.TILE_SWITCHBOARD.get());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.storage.cast();
        }
        return super.getCapability(cap, side);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("inventory", (INBT)this.itemStackHandler.serializeNBT());
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.itemStackHandler.deserializeNBT(compound.func_74775_l("inventory"));
    }

    public int getPowerLevel(int SlotID) {
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        if (this.isLinked(SlotID)) {
            CompoundNBT compound = stack.func_77978_p();
            BlockPos pos = new BlockPos(compound.func_74762_e("blockx"), compound.func_74762_e("blocky"), compound.func_74762_e("blockz"));
            SolarLight solar = (SolarLight)this.field_145850_b.func_175625_s(pos);
            return (int)((double)solar.getPowerLevel() / (double)solar.getMaxPowerLevel() * 23.0);
        }
        return 0;
    }

    public int getPowerLevelPer(int SlotID) {
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        if (this.isLinked(SlotID)) {
            CompoundNBT compound = stack.func_77978_p();
            BlockPos pos = new BlockPos(compound.func_74762_e("blockx"), compound.func_74762_e("blocky"), compound.func_74762_e("blockz"));
            SolarLight solar = (SolarLight)this.field_145850_b.func_175625_s(pos);
            return (int)((double)solar.getPowerLevel() / (double)solar.getMaxPowerLevel() * 100.0);
        }
        return 0;
    }

    public boolean getState(int SlotID) {
        CompoundNBT compound;
        BlockPos pos;
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        if (this.isLinked(SlotID) && this.field_145850_b.func_180495_p(pos = new BlockPos((compound = stack.func_77978_p()).func_74762_e("blockx"), compound.func_74762_e("blocky"), compound.func_74762_e("blockz"))).func_177230_c() instanceof RemoteSwitchable) {
            return ((RemoteSwitchable)this.field_145850_b.func_180495_p(pos).func_177230_c()).getPoweredState(this.field_145850_b.func_180495_p(pos));
        }
        return false;
    }

    public boolean getCharging(int SlotID) {
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        if (this.isLinked(SlotID)) {
            CompoundNBT compound = stack.func_77978_p();
            BlockPos pos = new BlockPos(compound.func_74762_e("blockx"), compound.func_74762_e("blocky"), compound.func_74762_e("blockz"));
            SolarLight solar = (SolarLight)this.field_145850_b.func_175625_s(pos);
            return solar.isCharging();
        }
        return false;
    }

    public boolean isLinked(int SlotID) {
        BlockPos pos;
        CompoundNBT compound;
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        return !stack.func_190926_b() && stack.func_77973_b() instanceof SwitchModule && stack.func_77978_p() != null && (compound = stack.func_77978_p()).func_74764_b("blockx") && compound.func_74764_b("blocky") && compound.func_74764_b("blockz") && this.field_145850_b.func_175625_s(pos = new BlockPos(compound.func_74762_e("blockx"), compound.func_74762_e("blocky"), compound.func_74762_e("blockz"))) != null && this.field_145850_b.func_175625_s(pos).func_145830_o() && this.field_145850_b.func_175625_s(pos) instanceof SolarLight;
    }

    public void toggleState(int SlotID) {
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        if (this.isLinked(SlotID)) {
            CompoundNBT compound = stack.func_77978_p();
            BlockPos pos = new BlockPos(compound.func_74762_e("blockx"), compound.func_74762_e("blocky"), compound.func_74762_e("blockz"));
            PacketStateToggle msg = new PacketStateToggle(pos);
            if (this.getPowerLevel(SlotID) > 0) {
                PacketHandler.INSTANCE.sendToServer((Object)msg);
            } else if (this.field_145850_b.func_217366_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0, false) != null) {
                this.field_145850_b.func_217366_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0, false).func_146105_b((ITextComponent)new TranslationTextComponent("Out of power"), true);
            }
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
    }

    public void dropInventory() {
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            if (this.itemStackHandler.getStackInSlot(i).func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.itemStackHandler.getStackInSlot(i));
        }
    }

    public static class SwitchItemStackHandler
    extends ItemStackHandler {
        public SwitchItemStackHandler(int size) {
            super(size);
        }

        public void setSize(int size) {
            super.setSize(size);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof SwitchModule;
        }
    }
}

