/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.utils.TagUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class IEApi {
    public static List<? extends String> modPreference;
    public static HashMap<ResourceLocation, ItemStack> oreOutputPreference;
    public static int revolverTextureSheetID;
    public static HashMap<String, Integer[]> prefixToIngotMap;
    public static Effect[] potions;
    public static List<Runnable> renderCacheClearers;
    public static List<Predicate<ItemStack>> forbiddenInCrates;

    public static ItemStack getPreferredTagStack(ResourceLocation name) {
        return oreOutputPreference.computeIfAbsent(name, rl -> {
            if (TagUtils.isNonemptyItemTag(name)) {
                return new ItemStack((IItemProvider)IEApi.getPreferredElementbyMod(ItemTags.func_199903_a().func_199910_a(name).func_199885_a()));
            }
            if (TagUtils.isNonemptyBlockTag(name)) {
                return new ItemStack((IItemProvider)IEApi.getPreferredElementbyMod(BlockTags.func_199896_a().func_199910_a(name).func_199885_a()));
            }
            return ItemStack.field_190927_a;
        }).func_77946_l();
    }

    public static <T extends IForgeRegistryEntry<T>> T getPreferredElementbyMod(Collection<T> list) {
        return (T)IEApi.getPreferredElementbyMod(list, IForgeRegistryEntry::getRegistryName);
    }

    public static ItemStack getPreferredStackbyMod(Collection<ItemStack> list) {
        return IEApi.getPreferredElementbyMod(list, e -> e.func_77973_b().getRegistryName());
    }

    public static <T> T getPreferredElementbyMod(Collection<T> list, Function<T, ResourceLocation> getName) {
        T preferredStack = null;
        int currBest = modPreference.size();
        for (T stack : list) {
            ResourceLocation rl = getName.apply(stack);
            if (rl == null) continue;
            String modId = rl.func_110624_b();
            int idx = modPreference.indexOf(modId);
            if (preferredStack != null && (idx < 0 || idx >= currBest)) continue;
            preferredStack = stack;
            currBest = idx;
        }
        return preferredStack;
    }

    public static ItemStack getPreferredStackbyMod(ItemStack[] array) {
        return IEApi.getPreferredElementbyMod(Lists.newArrayList((Object[])array), stack -> stack.func_77973_b().getRegistryName());
    }

    public static boolean isAllowedInCrate(ItemStack stack) {
        for (Predicate<ItemStack> check : forbiddenInCrates) {
            if (!check.test(stack)) continue;
            return false;
        }
        return true;
    }

    static {
        oreOutputPreference = new HashMap();
        prefixToIngotMap = new HashMap();
        renderCacheClearers = new ArrayList<Runnable>();
        forbiddenInCrates = new ArrayList<Predicate<ItemStack>>();
    }
}

