/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.common.blocks.EnumMetals;
import blusunrize.immersiveengineering.common.data.IEDataGenerator;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;

public class IETags {
    private static final Map<Tag<Block>, Tag<Item>> toItemTag = new HashMap<Tag<Block>, Tag<Item>>();
    private static final Map<EnumMetals, MetalTags> metals = new HashMap<EnumMetals, MetalTags>();
    public static final Tag<Item> clay = new ItemTags.Wrapper(IETags.forgeLoc("clay"));
    public static final Tag<Block> clayBlock = IETags.createBlockTag(IETags.getStorageBlock("clay"));
    public static final Tag<Item> charCoal = new ItemTags.Wrapper(IETags.forgeLoc("charcoal"));
    public static final Tag<Block> glowstoneBlock = IETags.createBlockTag(IETags.getStorageBlock("glowstone"));
    public static final Tag<Block> charCoalBlocks = IETags.createBlockTag(IETags.getStorageBlock("charcoal"));
    public static final Tag<Block> treatedWood = IETags.createBlockTag(IETags.forgeLoc("treated_wood"));
    public static final Tag<Block> treatedWoodSlab = IETags.createBlockTag(IETags.forgeLoc("treated_wood_slab"));
    public static final Tag<Block> coalCokeBlock = IETags.createBlockTag(IETags.getStorageBlock("coal_coke"));
    public static final Tag<Block> scaffoldingSteel = IETags.createBlockTag(IEDataGenerator.rl("scaffoldings/steel"));
    public static final Tag<Block> scaffoldingAlu = IETags.createBlockTag(IEDataGenerator.rl("scaffoldings/aluminum"));
    public static final Tag<Block> sheetmetals = IETags.createBlockTag(IETags.forgeLoc("sheetmetals"));
    public static final Tag<Item> treatedStick = new ItemTags.Wrapper(IETags.getRod("treated_wood"));
    public static final Tag<Item> ironRod = new ItemTags.Wrapper(IETags.getRod("iron"));
    public static final Tag<Item> steelRod = new ItemTags.Wrapper(IETags.getRod("steel"));
    public static final Tag<Item> metalRods = new ItemTags.Wrapper(IETags.getRod("all_metal"));
    public static final Tag<Item> aluminumRod = new ItemTags.Wrapper(IETags.getRod("aluminum"));
    public static final Tag<Item> fiberHemp = new ItemTags.Wrapper(IETags.forgeLoc("fiber_hemp"));
    public static final Tag<Item> fabricHemp = new ItemTags.Wrapper(IETags.forgeLoc("fabric_hemp"));
    public static final Tag<Item> coalCoke = new ItemTags.Wrapper(IETags.forgeLoc("coal_coke"));
    public static final Tag<Item> slag = new ItemTags.Wrapper(IETags.forgeLoc("slag"));
    public static final Tag<Item> coalCokeDust = new ItemTags.Wrapper(IETags.getDust("coal_coke"));
    public static final Tag<Item> hopGraphiteDust = new ItemTags.Wrapper(IETags.getDust("hop_graphite"));
    public static final Tag<Item> hopGraphiteIngot = new ItemTags.Wrapper(IETags.getIngot("hop_graphite"));
    public static final Tag<Item> copperWire = new ItemTags.Wrapper(IETags.getWire("copper"));
    public static final Tag<Item> electrumWire = new ItemTags.Wrapper(IETags.getWire("electrum"));
    public static final Tag<Item> aluminumWire = new ItemTags.Wrapper(IETags.getWire("aluminum"));
    public static final Tag<Item> steelWire = new ItemTags.Wrapper(IETags.getWire("steel"));
    public static final Tag<Item> saltpeterDust = new ItemTags.Wrapper(IETags.getDust("saltpeter"));
    public static final Tag<Item> sulfurDust = new ItemTags.Wrapper(IETags.getDust("sulfur"));
    public static final Tag<Item> plates = new ItemTags.Wrapper(IETags.forgeLoc("plates"));

    public static Tag<Item> getItemTag(Tag<Block> blockTag) {
        Preconditions.checkArgument((boolean)toItemTag.containsKey(blockTag));
        return toItemTag.get(blockTag);
    }

    public static MetalTags getTagsFor(EnumMetals metal) {
        return metals.get((Object)metal);
    }

    private static Tag<Block> createBlockTag(ResourceLocation name) {
        BlockTags.Wrapper blockTag = new BlockTags.Wrapper(name);
        toItemTag.put((Tag<Block>)blockTag, (Tag<Item>)new ItemTags.Wrapper(name));
        return blockTag;
    }

    public static void forAllBlocktags(BiConsumer<Tag<Block>, Tag<Item>> out) {
        for (Map.Entry<Tag<Block>, Tag<Item>> entry : toItemTag.entrySet()) {
            out.accept(entry.getKey(), entry.getValue());
        }
    }

    private static ResourceLocation forgeLoc(String path) {
        return new ResourceLocation("forge", path);
    }

    public static ResourceLocation getOre(String type) {
        return IETags.forgeLoc("ores/" + type);
    }

    public static ResourceLocation getNugget(String type) {
        return IETags.forgeLoc("nuggets/" + type);
    }

    public static ResourceLocation getIngot(String type) {
        return IETags.forgeLoc("ingots/" + type);
    }

    public static ResourceLocation getGem(String type) {
        return IETags.forgeLoc("gems/" + type);
    }

    public static ResourceLocation getStorageBlock(String type) {
        return IETags.forgeLoc("storage_blocks/" + type);
    }

    public static ResourceLocation getDust(String type) {
        return IETags.forgeLoc("dusts/" + type);
    }

    public static ResourceLocation getPlate(String type) {
        return IETags.forgeLoc("plates/" + type);
    }

    public static ResourceLocation getRod(String type) {
        return IETags.forgeLoc("rods/" + type);
    }

    public static ResourceLocation getGear(String type) {
        return IETags.forgeLoc("gears/" + type);
    }

    public static ResourceLocation getWire(String type) {
        return IETags.forgeLoc("wires/" + type);
    }

    public static ResourceLocation getSheetmetalBlock(String type) {
        return IETags.forgeLoc("sheetmetals/" + type);
    }

    static {
        for (EnumMetals m : EnumMetals.values()) {
            metals.put(m, new MetalTags(m));
        }
    }

    public static class MetalTags {
        public final Tag<Item> ingot;
        public final Tag<Item> nugget;
        public final Tag<Item> plate;
        public final Tag<Item> dust;
        public final Tag<Block> storage;
        public final Tag<Block> sheetmetal;
        @Nullable
        public final Tag<Block> ore;

        private MetalTags(EnumMetals m) {
            String name = m.tagName();
            Tag ore = null;
            if (m.shouldAddOre()) {
                ore = IETags.createBlockTag(IETags.getOre(name));
            }
            if (!m.isVanillaMetal()) {
                this.storage = IETags.createBlockTag(IETags.getStorageBlock(name));
            } else if (m == EnumMetals.IRON) {
                this.storage = Tags.Blocks.STORAGE_BLOCKS_IRON;
                ore = Tags.Blocks.ORES_IRON;
            } else if (m == EnumMetals.GOLD) {
                this.storage = Tags.Blocks.STORAGE_BLOCKS_GOLD;
                ore = Tags.Blocks.ORES_GOLD;
            } else {
                throw new RuntimeException("Unkown vanilla metal: " + m.name());
            }
            this.sheetmetal = IETags.createBlockTag(IETags.getSheetmetalBlock(name));
            this.nugget = new ItemTags.Wrapper(IETags.getNugget(name));
            this.ingot = new ItemTags.Wrapper(IETags.getIngot(name));
            this.plate = new ItemTags.Wrapper(IETags.getPlate(name));
            this.dust = new ItemTags.Wrapper(IETags.getDust(name));
            this.ore = ore;
        }
    }
}

