/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.common.util.ListUtils;
import com.google.common.collect.Lists;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.RegistryObject;

public class BottlingMachineRecipe
extends MultiblockRecipe {
    public static IRecipeType<BottlingMachineRecipe> TYPE = IRecipeType.func_222147_a((String)"immersiveengineering:bottling_machine");
    public static RegistryObject<IERecipeSerializer<BottlingMachineRecipe>> SERIALIZER;
    public final Ingredient input;
    public final FluidStack fluidInput;
    public final ItemStack output;
    public static Map<ResourceLocation, BottlingMachineRecipe> recipeList;

    public BottlingMachineRecipe(ResourceLocation id, ItemStack output, Ingredient input, FluidStack fluidInput) {
        super(output, TYPE, id);
        this.output = output;
        this.input = input;
        this.fluidInput = fluidInput;
        this.setInputList(Lists.newArrayList((Object[])new Ingredient[]{this.input}));
        this.fluidInputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidInput});
        this.outputList = ListUtils.fromItem(this.output);
    }

    @Override
    protected IERecipeSerializer<BottlingMachineRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public static BottlingMachineRecipe findRecipe(ItemStack input, FluidStack fluid) {
        if (!input.func_190926_b() && fluid != null) {
            for (BottlingMachineRecipe recipe : recipeList.values()) {
                if (!ItemUtils.stackMatchesObject(input, recipe.input) || !fluid.containsFluid(recipe.fluidInput)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }
}

