/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public class ClocheRecipe
extends IESerializableRecipe {
    public static IRecipeType<ClocheRecipe> TYPE = IRecipeType.func_222147_a((String)"immersiveengineering:cloche");
    public static RegistryObject<IERecipeSerializer<ClocheRecipe>> SERIALIZER;
    public final List<ItemStack> outputs;
    public final Ingredient seed;
    public final Ingredient soil;
    public final int time;
    public final ClocheRenderFunction.ClocheRenderReference renderReference;
    public final ClocheRenderFunction renderFunction;
    public static Map<ResourceLocation, ClocheRecipe> recipeList;
    private static List<Pair<Ingredient, ResourceLocation>> soilTextureList;

    public ClocheRecipe(ResourceLocation id, List<ItemStack> outputs, Ingredient seed, Ingredient soil, int time, ClocheRenderFunction.ClocheRenderReference renderReference) {
        super(outputs.get(0), TYPE, id);
        this.outputs = outputs;
        this.seed = seed;
        this.soil = soil;
        this.time = time;
        this.renderReference = renderReference;
        this.renderFunction = (ClocheRenderFunction)ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.get(renderReference.getType()).apply(renderReference.getBlock());
    }

    public ClocheRecipe(ResourceLocation id, ItemStack output, Ingredient seed, Ingredient soil, int time, ClocheRenderFunction.ClocheRenderReference renderReference) {
        this(id, (List<ItemStack>)ImmutableList.of((Object)output), seed, soil, time, renderReference);
    }

    @Override
    protected IERecipeSerializer<ClocheRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack func_77571_b() {
        return this.outputs.get(0);
    }

    public static ClocheRecipe findRecipe(ItemStack seed, ItemStack soil) {
        for (ClocheRecipe recipe : recipeList.values()) {
            if (!ItemUtils.stackMatchesObject(seed, recipe.seed) || !ItemUtils.stackMatchesObject(soil, recipe.soil)) continue;
            return recipe;
        }
        return null;
    }

    public static void registerSoilTexture(Ingredient soil, ResourceLocation texture) {
        soilTextureList.add((Pair<Ingredient, ResourceLocation>)Pair.of((Object)soil, (Object)texture));
    }

    public static ResourceLocation getSoilTexture(ItemStack soil) {
        for (Pair<Ingredient, ResourceLocation> entry : soilTextureList) {
            if (!((Ingredient)entry.getKey()).test(soil)) continue;
            return (ResourceLocation)entry.getValue();
        }
        return null;
    }

    static {
        soilTextureList = new ArrayList<Pair<Ingredient, ResourceLocation>>();
    }
}

