/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import com.google.common.base.Preconditions;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;

public class StackWithChance {
    private final ItemStack stack;
    private final float chance;

    public StackWithChance(ItemStack stack, float chance) {
        Preconditions.checkNotNull((Object)stack);
        this.stack = stack;
        this.chance = chance;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public float getChance() {
        return this.chance;
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_218657_a("stack", (INBT)this.stack.func_77955_b(new CompoundNBT()));
        compoundNBT.func_74776_a("chance", this.chance);
        return compoundNBT;
    }

    public static StackWithChance readFromNBT(CompoundNBT compoundNBT) {
        Preconditions.checkNotNull((Object)compoundNBT);
        Preconditions.checkArgument((boolean)compoundNBT.func_74764_b("chance"));
        Preconditions.checkArgument((boolean)compoundNBT.func_74764_b("stack"));
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)compoundNBT.func_74775_l("stack"));
        float chance = compoundNBT.func_74760_g("chance");
        return new StackWithChance(stack, chance);
    }

    public void write(PacketBuffer buffer) {
        buffer.func_150788_a(this.stack);
        buffer.writeFloat(this.chance);
    }

    public static StackWithChance read(PacketBuffer buffer) {
        return new StackWithChance(buffer.func_150791_c(), buffer.readFloat());
    }

    public StackWithChance recalculate(float totalChance) {
        return new StackWithChance(this.stack, this.chance / totalChance);
    }
}

