/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.ApiUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;

public class DieselHandler {
    static final HashMap<ResourceLocation, Integer> dieselGenBurnTime = new HashMap();
    static final Set<Fluid> drillFuel = new HashSet<Fluid>();

    public static void registerFuel(Fluid fuel, int time) {
        if (fuel != null) {
            dieselGenBurnTime.put(fuel.getRegistryName(), time);
        }
    }

    public static int getBurnTime(Fluid fuel) {
        ResourceLocation s;
        if (fuel != null && dieselGenBurnTime.containsKey(s = fuel.getRegistryName())) {
            return dieselGenBurnTime.get(s);
        }
        return 0;
    }

    public static boolean isValidFuel(Fluid fuel) {
        if (fuel != null) {
            return dieselGenBurnTime.containsKey(fuel.getRegistryName());
        }
        return false;
    }

    public static HashMap<ResourceLocation, Integer> getFuelValues() {
        return dieselGenBurnTime;
    }

    public static Map<ResourceLocation, Integer> getFuelValuesSorted(boolean inverse) {
        return ApiUtils.sortMap(dieselGenBurnTime, inverse);
    }

    public static void registerDrillFuel(Fluid fuel) {
        if (fuel != null) {
            drillFuel.add(fuel);
        }
    }

    public static boolean isValidDrillFuel(Fluid fuel) {
        return fuel != null && drillFuel.contains(fuel);
    }

    public static void removeFuel(Fluid fuel) {
        if (fuel != null) {
            dieselGenBurnTime.remove(fuel.getRegistryName());
        }
    }

    public static void removeDrillFuel(Fluid fuel) {
        drillFuel.remove(fuel);
    }
}

