/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.multiblocks.BlockMatcher;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.StaticTemplateManager;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TemplateMultiblock
implements MultiblockHandler.IMultiblock {
    private final ResourceLocation loc;
    protected final BlockPos masterFromOrigin;
    protected final BlockPos triggerFromOrigin;
    protected final List<BlockMatcher.MatcherPredicate> additionalPredicates;
    @Nullable
    private Template template;
    @Nullable
    private ItemStack[] materials;
    private BlockState trigger = Blocks.field_150350_a.func_176223_P();

    public TemplateMultiblock(ResourceLocation loc, BlockPos masterFromOrigin, BlockPos triggerFromOrigin, List<BlockMatcher.MatcherPredicate> additionalPredicates) {
        this.loc = loc;
        this.masterFromOrigin = masterFromOrigin;
        this.triggerFromOrigin = triggerFromOrigin;
        this.additionalPredicates = additionalPredicates;
    }

    public TemplateMultiblock(ResourceLocation loc, BlockPos masterFromOrigin, BlockPos triggerFromOrigin) {
        this(loc, masterFromOrigin, triggerFromOrigin, (Map<Block, Tag<Block>>)ImmutableMap.of());
    }

    public TemplateMultiblock(ResourceLocation loc, BlockPos masterFromOrigin, BlockPos triggerFromOrigin, Map<Block, Tag<Block>> tags) {
        this(loc, masterFromOrigin, triggerFromOrigin, (List<BlockMatcher.MatcherPredicate>)ImmutableList.of((expected, found, world, pos) -> {
            Tag tag = (Tag)tags.get(expected.func_177230_c());
            if (tag != null) {
                if (found.func_203425_a(tag)) {
                    return BlockMatcher.Result.allow(2);
                }
                return BlockMatcher.Result.deny(2);
            }
            return BlockMatcher.Result.DEFAULT;
        }));
    }

    @Nonnull
    protected Template getTemplate() {
        if (this.template == null) {
            try {
                this.template = StaticTemplateManager.loadStaticTemplate(this.loc);
                List blocks = (List)this.template.field_204769_a.get(0);
                for (int i = 0; i < blocks.size(); ++i) {
                    Template.BlockInfo info = (Template.BlockInfo)blocks.get(i);
                    if (info.field_186242_a.equals((Object)this.triggerFromOrigin)) {
                        this.trigger = info.field_186243_b;
                    }
                    if (info.field_186243_b == Blocks.field_150350_a.func_176223_P()) {
                        blocks.remove(i);
                        --i;
                        continue;
                    }
                    if (!info.field_186243_b.func_196958_f()) continue;
                    IELogger.error("Found non-default air block in template " + this.loc);
                }
                this.materials = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.template;
    }

    @Override
    public ResourceLocation getUniqueName() {
        return this.loc;
    }

    @Override
    public boolean isBlockTrigger(BlockState state) {
        this.getTemplate();
        return state.func_177230_c() == this.trigger.func_177230_c();
    }

    @Override
    public boolean createStructure(World world, BlockPos pos, Direction side, PlayerEntity player) {
        Rotation rot;
        if (side.func_176740_k() == Direction.Axis.Y) {
            side = Direction.func_176733_a((double)player.field_70177_z).func_176734_d();
        }
        if ((rot = Utils.getRotationBetweenFacings(Direction.NORTH, side.func_176734_d())) == null) {
            return false;
        }
        Template template = this.getTemplate();
        ImmutableList mirrorStates = this.canBeMirrored() ? ImmutableList.of((Object)Mirror.NONE, (Object)Mirror.FRONT_BACK) : ImmutableList.of((Object)Mirror.NONE);
        block0: for (Mirror mirror : mirrorStates) {
            PlacementSettings placeSet = new PlacementSettings().func_186214_a(mirror).func_186220_a(rot);
            BlockPos origin = pos.func_177973_b((Vec3i)Template.func_186266_a((PlacementSettings)placeSet, (BlockPos)this.triggerFromOrigin));
            for (Template.BlockInfo info : (List)template.field_204769_a.get(0)) {
                BlockState inWorld;
                BlockPos realRelPos = Template.func_186266_a((PlacementSettings)placeSet, (BlockPos)info.field_186242_a);
                BlockPos here = origin.func_177971_a((Vec3i)realRelPos);
                BlockState expected = info.field_186243_b.func_185902_a(mirror).func_185907_a(rot);
                if (BlockMatcher.matches(expected, inWorld = world.func_180495_p(here), world, here, this.additionalPredicates).isAllow()) continue;
                continue block0;
            }
            this.form(world, origin, rot, mirror, side);
            return true;
        }
        return false;
    }

    protected void form(World world, BlockPos pos, Rotation rot, Mirror mirror, Direction sideHit) {
        BlockPos masterPos = TemplateMultiblock.withSettingsAndOffset(pos, this.masterFromOrigin, mirror, rot);
        for (Template.BlockInfo block : this.getStructure()) {
            BlockPos actualPos = TemplateMultiblock.withSettingsAndOffset(pos, block.field_186242_a, mirror, rot);
            this.replaceStructureBlock(block, world, actualPos, mirror != Mirror.NONE, sideHit, (Vec3i)actualPos.func_177973_b((Vec3i)masterPos));
        }
    }

    protected abstract void replaceStructureBlock(Template.BlockInfo var1, World var2, BlockPos var3, boolean var4, Direction var5, Vec3i var6);

    @Override
    public List<Template.BlockInfo> getStructure() {
        return (List)this.getTemplate().field_204769_a.get(0);
    }

    @Override
    public Vec3i getSize() {
        return this.getTemplate().func_186259_a();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean overwriteBlockRender(BlockState state, int iterator) {
        return false;
    }

    public static BlockPos withSettingsAndOffset(BlockPos origin, BlockPos relative, Mirror mirror, Rotation rot) {
        PlacementSettings settings = new PlacementSettings().func_186214_a(mirror).func_186220_a(rot);
        return origin.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)settings, (BlockPos)relative));
    }

    public static BlockPos withSettingsAndOffset(BlockPos origin, BlockPos relative, boolean mirrored, Direction facing) {
        Rotation rot = Utils.getRotationBetweenFacings(Direction.NORTH, facing);
        if (rot == null) {
            return origin;
        }
        return TemplateMultiblock.withSettingsAndOffset(origin, relative, mirrored ? Mirror.FRONT_BACK : Mirror.NONE, rot);
    }

    @Override
    public ItemStack[] getTotalMaterials() {
        if (this.materials == null) {
            List<Template.BlockInfo> structure = this.getStructure();
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>(structure.size());
            BlockRayTraceResult rtr = new BlockRayTraceResult(Vec3d.field_186680_a, Direction.DOWN, BlockPos.field_177992_a, false);
            for (Template.BlockInfo info : structure) {
                ItemStack picked = Utils.getPickBlock(info.field_186243_b, (RayTraceResult)rtr, ImmersiveEngineering.proxy.getClientPlayer());
                boolean added = false;
                for (ItemStack existing : ret) {
                    if (!ItemStack.func_179545_c((ItemStack)existing, (ItemStack)picked)) continue;
                    existing.func_190917_f(1);
                    added = true;
                    break;
                }
                if (added) continue;
                ret.add(picked.func_77946_l());
            }
            this.materials = ret.toArray(new ItemStack[0]);
        }
        return this.materials;
    }

    @Override
    public void disassemble(World world, BlockPos origin, boolean mirrored, Direction clickDirectionAtCreation) {
        Mirror mirror = mirrored ? Mirror.FRONT_BACK : Mirror.NONE;
        Rotation rot = Utils.getRotationBetweenFacings(Direction.NORTH, clickDirectionAtCreation);
        Preconditions.checkNotNull((Object)rot);
        for (Template.BlockInfo block : this.getStructure()) {
            BlockPos actualPos = TemplateMultiblock.withSettingsAndOffset(origin, block.field_186242_a, mirror, rot);
            this.prepareBlockForDisassembly(world, actualPos);
            world.func_175656_a(actualPos, block.field_186243_b.func_185902_a(mirror).func_185907_a(rot));
        }
    }

    protected void prepareBlockForDisassembly(World world, BlockPos pos) {
    }

    @Override
    public BlockPos getTriggerOffset() {
        return this.triggerFromOrigin;
    }

    public boolean canBeMirrored() {
        return true;
    }
}

