/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import java.util.List;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeEntityMinecart;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CapabilityUtils {
    public static LazyOptional<IItemHandler> findItemHandlerAtPos(World world, BlockPos pos, Direction side, boolean allowCart) {
        LazyOptional cap;
        List list;
        LazyOptional cap2;
        TileEntity neighbourTile = world.func_175625_s(pos);
        if (neighbourTile != null && (cap2 = neighbourTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)).isPresent()) {
            return cap2;
        }
        if (allowCart && AbstractRailBlock.func_208488_a((World)world, (BlockPos)pos) && !(list = world.func_175674_a(null, new AxisAlignedBB(pos), entity -> entity instanceof IForgeEntityMinecart)).isEmpty() && (cap = ((Entity)list.get(world.field_73012_v.nextInt(list.size()))).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
            return cap;
        }
        return LazyOptional.empty();
    }

    public static boolean canInsertStackIntoInventory(TileEntity inventory, ItemStack stack, Direction side) {
        if (!stack.func_190926_b() && inventory != null) {
            return (Boolean)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(handler -> {
                ItemStack temp = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)true);
                return temp.func_190926_b() || temp.func_190916_E() < stack.func_190916_E();
            }).orElse((Object)false);
        }
        return false;
    }

    public static ItemStack insertStackIntoInventory(TileEntity inventory, ItemStack stack, Direction side) {
        if (!stack.func_190926_b() && inventory != null) {
            return (ItemStack)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(handler -> {
                ItemStack temp = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)true);
                if (temp.func_190926_b() || temp.func_190916_E() < stack.func_190916_E()) {
                    return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                }
                return stack;
            }).orElse((Object)stack);
        }
        return stack;
    }

    public static ItemStack insertStackIntoInventory(TileEntity inventory, ItemStack stack, Direction side, boolean simulate) {
        if (inventory != null && !stack.func_190926_b()) {
            return (ItemStack)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)simulate)).orElse((Object)stack);
        }
        return stack;
    }

    public static <T> LazyOptional<T> constantOptional(T val) {
        return LazyOptional.of(() -> val);
    }
}

