/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class ItemUtils {
    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        return ItemUtils.stackMatchesObject(stack, o, false);
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o, boolean checkNBT) {
        if (o instanceof ItemStack) {
            return ItemStack.func_179545_c((ItemStack)((ItemStack)o), (ItemStack)stack) && (!checkNBT || Utils.compareItemNBT((ItemStack)o, stack));
        }
        if (o instanceof Collection) {
            for (Object io : (Collection)o) {
                if (!ItemUtils.stackMatchesObject(stack, io, checkNBT)) continue;
                return true;
            }
        } else {
            if (o instanceof IngredientWithSize) {
                return ((IngredientWithSize)o).test(stack);
            }
            if (o instanceof Ingredient) {
                return ((Ingredient)o).test(stack);
            }
            if (o instanceof ItemStack[]) {
                for (ItemStack io : (ItemStack[])o) {
                    if (!ItemStack.func_179545_c((ItemStack)io, (ItemStack)stack) || checkNBT && !Utils.compareItemNBT(io, stack)) continue;
                    return true;
                }
            } else {
                if (o instanceof FluidStack) {
                    return (Boolean)FluidUtil.getFluidContained((ItemStack)stack).map(fs -> fs.containsFluid((FluidStack)o)).orElse((Object)false);
                }
                if (o instanceof ResourceLocation) {
                    return TagUtils.isInBlockOrItemTag(stack, (ResourceLocation)o);
                }
                throw new IllegalArgumentException("Comparison object " + o + " of class " + o.getClass() + " is invalid!");
            }
        }
        return false;
    }

    public static ItemStack copyStackWithAmount(ItemStack stack, int amount) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack s2 = stack.func_77946_l();
        s2.func_190920_e(amount);
        return s2;
    }
}

