/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

@OnlyIn(value=Dist.CLIENT)
public class QuadTransformer
implements Function<BakedQuad, BakedQuad> {
    @Nonnull
    private final TransformationMatrix transform;
    @Nullable
    private final Int2IntFunction colorTransform;
    private BakedQuadBuilder currentQuadBuilder;
    private final IVertexConsumer transformer = this.createConsumer(DefaultVertexFormats.field_176600_a);

    public QuadTransformer(TransformationMatrix transform, @Nullable Int2IntFunction colorTransform) {
        this.transform = transform;
        this.colorTransform = colorTransform;
    }

    @Override
    public BakedQuad apply(BakedQuad q) {
        this.currentQuadBuilder = new BakedQuadBuilder();
        q.pipe(this.transformer);
        return this.currentQuadBuilder.build();
    }

    private IVertexConsumer createConsumer(final VertexFormat f) {
        int posPos = -1;
        int normPos = -1;
        int colorPos = -1;
        for (int i = 0; i < f.func_227894_c_().size(); ++i) {
            if (((VertexFormatElement)f.func_227894_c_().get(i)).func_177375_c() == VertexFormatElement.Usage.POSITION) {
                posPos = i;
                continue;
            }
            if (((VertexFormatElement)f.func_227894_c_().get(i)).func_177375_c() == VertexFormatElement.Usage.NORMAL) {
                normPos = i;
                continue;
            }
            if (((VertexFormatElement)f.func_227894_c_().get(i)).func_177375_c() != VertexFormatElement.Usage.COLOR) continue;
            colorPos = i;
        }
        if (posPos == -1) {
            return null;
        }
        final int posPosFinal = posPos;
        final int normPosFinal = normPos;
        final int colorPosFinal = colorPos;
        return new IVertexConsumer(){
            int tintIndex = -1;

            @Nonnull
            public VertexFormat getVertexFormat() {
                return f;
            }

            public void setQuadTint(int tint) {
                QuadTransformer.this.currentQuadBuilder.setQuadTint(tint);
                this.tintIndex = tint;
            }

            public void setQuadOrientation(@Nonnull Direction orientation) {
                Vec3i normal = orientation.func_176730_m();
                Vector3f newFront = new Vector3f((float)normal.func_177958_n(), (float)normal.func_177956_o(), (float)normal.func_177952_p());
                QuadTransformer.this.transform.transformNormal(newFront);
                Direction newOrientation = Direction.func_176737_a((float)newFront.func_195899_a(), (float)newFront.func_195900_b(), (float)newFront.func_195902_c());
                QuadTransformer.this.currentQuadBuilder.setQuadOrientation(newOrientation);
            }

            public void setApplyDiffuseLighting(boolean diffuse) {
                QuadTransformer.this.currentQuadBuilder.setApplyDiffuseLighting(diffuse);
            }

            public void setTexture(@Nonnull TextureAtlasSprite texture) {
                QuadTransformer.this.currentQuadBuilder.setTexture(texture);
            }

            public void put(int element, float ... data) {
                int multiplier;
                if (element == posPosFinal && QuadTransformer.this.transform != null) {
                    Vector4f newPos = new Vector4f(data[0], data[1], data[2], 1.0f);
                    QuadTransformer.this.transform.transformPosition(newPos);
                    data = new float[]{newPos.func_195910_a(), newPos.func_195913_b(), newPos.func_195914_c()};
                } else if (element == normPosFinal) {
                    Vector3f newNormal = new Vector3f(data[0], data[1], data[2]);
                    QuadTransformer.this.transform.transformNormal(newNormal);
                    data = new float[]{newNormal.func_195899_a(), newNormal.func_195900_b(), newNormal.func_195902_c()};
                } else if (element == colorPosFinal && this.tintIndex != -1 && QuadTransformer.this.colorTransform != null && (multiplier = ((Integer)QuadTransformer.this.colorTransform.apply((Object)this.tintIndex)).intValue()) != 0) {
                    float r = (float)(multiplier >> 16 & 0xFF) / 255.0f;
                    float g = (float)(multiplier >> 8 & 0xFF) / 255.0f;
                    float b = (float)(multiplier & 0xFF) / 255.0f;
                    float[] oldData = data;
                    data = new float[]{oldData[0] * r, oldData[1] * g, oldData[2] * b, oldData[3]};
                }
                QuadTransformer.this.currentQuadBuilder.put(element, data);
            }
        };
    }
}

